﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/codec/detail/codec_OpusCommonInternal.h>

namespace nn {
namespace codec {

int GetOpusBitRateMin(int channelCount) NN_NOEXCEPT
{
    NN_UNUSED(channelCount);
    NN_SDK_REQUIRES(channelCount == 1 || channelCount == 2);
    return detail::BitRateMin;
}

int GetOpusBitRateMax(int channelCount) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(channelCount == 1 || channelCount == 2);
    return channelCount == 1 ? detail::BitRateMaxForMonoral : detail::BitRateMaxForStereo;
}

}}  // nn::codec
