﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/lmem/lmem_ExpHeap.h>

#include <nn/sf/impl/sf_ExpHeapAllocator.h>

#include <nn/codec/detail/codec_IHardwareOpusDecoderManager.h>
#include <nn/codec/detail/codec_IHardwareOpusDecoder.h>
#include <nn/codec/detail/codec_HardwareOpusCommon-spec.NX.h>

#include "detail/codec_HardwareOpusDecoderManagerImpl-spec.NX.h"

namespace nn { namespace codec {

class HardwareOpusDecoderManagerImpl : public nn::sf::ISharedObject
{
public:
    HardwareOpusDecoderManagerImpl() NN_NOEXCEPT;
    ~HardwareOpusDecoderManagerImpl() NN_NOEXCEPT;

    nn::Result OpenHardwareOpusDecoder(
        nn::sf::Out<nn::sf::SharedPointer<detail::IHardwareOpusDecoder>> outHardwareOpusDecoder,
        const detail::HardwareOpusDecoderParameterInternal& parameter,
        nn::sf::NativeHandle sfHandle,
        int workBufferSize) NN_NOEXCEPT;
    nn::Result OpenHardwareOpusDecoderForMultiStream(
        nn::sf::Out<nn::sf::SharedPointer<detail::IHardwareOpusDecoder>> outHardwareOpusDecoder,
        const detail::HardwareOpusMultiStreamDecoderParameterInternal& parameter,
        nn::sf::NativeHandle sfHandle,
        int workBufferSize) NN_NOEXCEPT;
    nn::Result GetWorkBufferSize(
        nn::sf::Out<int> outSize,
        const detail::HardwareOpusDecoderParameterInternal& parameter) NN_NOEXCEPT;
    nn::Result GetWorkBufferSizeForMultiStream(
        nn::sf::Out<int> outSize,
        const detail::HardwareOpusMultiStreamDecoderParameterInternal& parameter) NN_NOEXCEPT;

private:
    typedef nn::sf::ExpHeapAllocator MyAllocator;
    MyAllocator m_Allocator;
    static const int HeapBufferSize = detail::HardwareOpusDecoderIpcConstants_SessionHeapSize;
    std::aligned_storage<HeapBufferSize>::type m_HeapBuffer;
    nn::lmem::HeapHandle m_HeapHandle;
    class HardwareOpusDecoderImpl;
};

}}  // namespace nn::codec
