﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>

namespace nn { namespace codec {

int ExecuteDurbin(double* ac, int order, double* ref, double* taps, double* e2);
void CalculateTapFromReflection(double* ref, double* taps, int order);
int CalculateReflectionFromTap(double* ref, double* taps, int order);
void CalculateAutoCorrelationFromTapOrder2(double* a, int n, double* r);
void CalculateAutoCorrelationFromTap(double* a, int n, double* r);
double CalculateModelDistanceOrder2(double* ta, double* sa, int order);
double CalculateModelDistance(double* ta, double* sa, int order);
void CalculateAutoCorrelationMatrix(int16_t* input, int order, int length, double** a);
void CalculateAutoCorrelationVector(int16_t* input, int order, int length, double* a);
int ExecuteLuComposition(double** a, int n, int32_t* index);
void SolveEquationWithLuDecomposition(double** a, int n, int32_t* index, double* b);

}}  // namespace nn::codec
