﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.hdcp.detail
{
    [CppRefPath("<nn/hdcp/detail/hdcp_IHdcpController.h>")]
    public interface IHdcpController : IServiceObject
    {
    }
}

namespace nn.cec
{
    [CppRefPath("\"cec_ICecManager.h\"")]
    interface ICecManager : IServiceObject
    {
        [MethodId(0)]
        int32_t RegisterCallback(Out<NativeHandle> registrationEventHandle, Out<uint32_t> handleValue);

        [MethodId(1)]
        int32_t UnregisterCallback(uint32_t handleValue);

        [MethodId(2)]
        Result TriggerSystemEvent(uint32_t handleValue);

        [MethodId(3)]
        int32_t PerformAction(uint32_t action, uint64_t dataZero, uint64_t dataOne);

        [MethodId(4)]
        int32_t QueryState(uint32_t query, Out<uint64_t> pDataZero, Out<uint64_t> pDataOne);

        [MethodId(5)]
        int32_t OnSystemEvent(Out<uint32_t> pEvent, Out<uint32_t> pCount, Out<uint64_t> pDataZero, Out<uint64_t> pDataOne);

        [MethodId(6)]
        int32_t CancelCurrentCall(Out<bool> pCallWasCanceled);

        [MethodId(100)]
        Result GetHdcpServiceObject(Out<nn.hdcp.detail.IHdcpController> outService);
    }
}
