﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>

namespace nn { namespace cec { namespace detail {

const int32_t TransmitAckNakValueAck = 0;
const int32_t TransmitAckNakValueNak = 1;
const int32_t TransmitAckNakValueOther = 2;

typedef struct {
    int32_t error;
    int32_t ackNak;
} TransmitReturnValueType;

void    CecTransmitInit() NN_NOEXCEPT;
void    CecTransmitShutdown() NN_NOEXCEPT;
void    CecTransmitSetCancelState() NN_NOEXCEPT;
void    CecTransmitClearCancelState() NN_NOEXCEPT;
int32_t CecTransmitPollingRequest(TransmitReturnValueType* pReturnValue, uint8_t pollValue) NN_NOEXCEPT;
int32_t CecTransmitBestEffort(uint8_t* pBuffer, uint8_t count, bool isDirectAddressed) NN_NOEXCEPT;

}
}   // namespace cec
}   // namespace nn
