﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>
#include <nn/os/os_MutexTypes.h>

namespace nn { namespace cec { namespace detail {

typedef struct {
    nn::os::MutexType       mutex;
    uint8_t                 physAddr[2];
    uint8_t                 logicalAddress;
    uint8_t                 powerState;
    uint8_t                 opStatus;
} OperatingStateType;

const uint16_t TopLevelMadeUpPhysicalAddress = 0x1000;
const uint16_t TopLevelInvalidPhysicalAddresses[] =
{
    0x0000,
    0xFFFF
};
const uint8_t InvalidPhysicalAddressTvIndex = 0;
const uint8_t InvalidPhysicalAddressNotAnAddressIndex = 1;

const uint8_t CecPowerStatePowerOn   = 0;
const uint8_t CecPowerStateStandby   = 1;
const uint8_t CecPowerStatePowerToOn = 2;
const uint8_t CecPowerStateToStandby = 3;

const uint8_t CecOpStatusFlagInitializationOk = 1 << 0;
const uint8_t CecOpStatusFlagActiveSource     = 1 << 1;
const uint8_t CecOpStatusFlagCecEnabled       = 1 << 2;
const uint8_t CecOpStatusFlagPhysicalAddress  = 1 << 3;
const uint8_t CecOpStatusFlagMenuActiveState  = 1 << 4;

typedef void (*SendFeatureAbortType)(uint8_t, uint8_t, uint8_t, uint8_t);

typedef struct {
    nn::os::MutexType       mutex;
    char                    edidManufacturerName[4];
    SendFeatureAbortType    featureAbortHandler;
    uint32_t                flags;
} EdidVariationType;

const uint32_t  EdidVariationFlagsSlowOtpSequenceBit = (1 << 0);
const uint32_t  EdidVariationFlagsNoOsdReply = (1 << 1);

int32_t CecTopLevelInit() NN_NOEXCEPT;
void    CecTopLevelShutdown() NN_NOEXCEPT;
int32_t CecTopLevelPingTv(bool* pOutIsPingSuccessful) NN_NOEXCEPT;
uint8_t CecTopLevelGetPowerStatus() NN_NOEXCEPT;
void    CecTopLevelUpdatePowerStatus(uint8_t curPowerState) NN_NOEXCEPT;
int32_t CecTopLevelCheckCecSystemSettings() NN_NOEXCEPT;
int32_t CecTopLevelStart() NN_NOEXCEPT;
void    CecTopLevelOnHpd(bool isHigh) NN_NOEXCEPT;
int32_t CecTopLevelPerformActiveSource(bool setActiveSource) NN_NOEXCEPT;
int32_t CecTopLevelGoStandby(bool tvOnly) NN_NOEXCEPT;
void    CecTopLevelHandleReceivedStandby() NN_NOEXCEPT;
void    CecTopLevelOnTvPowerOffChange() NN_NOEXCEPT;
void    CecTopLevelOnTvPowerGoingOnChange() NN_NOEXCEPT;
void    CecTopLevelOnActiveSourceStateChange() NN_NOEXCEPT;
bool    CecTopLevelIsActiveSource() NN_NOEXCEPT;
void    CecTopLevelSetActiveSourceState(bool activeSource) NN_NOEXCEPT;
int32_t CecTopLevelSendDeviceMenuStateCommand(bool activate) NN_NOEXCEPT;
int32_t CecTopLevelSendRemoteControlCommand(bool start, uint8_t argument) NN_NOEXCEPT;
int32_t CecTopLevelSetOnScreenDisplay(uint8_t* string) NN_NOEXCEPT;
bool    CecTopLevelSetCancelState() NN_NOEXCEPT;
int32_t CecTopLevelIsStarted(bool* pIsStarted) NN_NOEXCEPT;
int32_t CecTopLevelGetTvPowerStatus(uint8_t* pOutTvPowerState) NN_NOEXCEPT;
int32_t CecTopLevelStop() NN_NOEXCEPT;

}
}   // namespace cec
}   // namespace nn
