﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>

namespace nn { namespace cec { namespace detail {

int32_t CecManagerGetTvPowerStatus(uint8_t* pOutPowerState, uint8_t logicalAddress) NN_NOEXCEPT;
bool CecManagerSequenceCompletionHandler(uint8_t* cecBuffer, uint8_t cecBufferByteCount) NN_NOEXCEPT;
void CecManagerSequenceCancellationHandler() NN_NOEXCEPT;
bool CecManagerInit(bool startCec) NN_NOEXCEPT;
void CecManagerShutdown() NN_NOEXCEPT;
void CecManagerHandleActiveSource(uint8_t sourceLogicalAddress, bool isSame, bool isRoutingChange) NN_NOEXCEPT;
void CecManagerHandleGoStandby() NN_NOEXCEPT;
void CecManagerHandleCecVersion(uint8_t sourceLogicalAddress, uint8_t cecVersion) NN_NOEXCEPT;
void CecManagerHandleFeatureAbort(uint8_t sourceLogicalAddress, uint8_t opcode, uint8_t reason) NN_NOEXCEPT;
void CecManagerHandleReportPowerStatus(uint8_t sourceLogicalAddress, uint8_t powerStatus) NN_NOEXCEPT;
bool CecManagerHandleVendorCommand(uint8_t sourceLogicalAddress, uint8_t count, uint8_t* pData) NN_NOEXCEPT;
bool CecManagerHandleVendorCommandWithId(uint8_t sourceLogicalAddress, uint8_t* pVendorId, uint8_t count, uint8_t* pData) NN_NOEXCEPT;
bool CecManagerHandleVendorRemoteControlButtonDown(uint8_t sourceLogicalAddress, uint8_t count, uint8_t* pRemoteControlButtonData) NN_NOEXCEPT;
bool CecManagerHandleVendorRemoteControlButtonUp(uint8_t sourceLogicalAddress) NN_NOEXCEPT;
void CecManagerHandleDeviceVendorId(uint8_t sourceLogicalAddress, uint8_t* pVendorId) NN_NOEXCEPT;

}
}   // namespace cec
}   // namespace nn
