﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/hdcp/detail/hdcp_IHdcpController.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace cec { // NOLINT(whitespace/braces)

class ICecManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ICecManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ICecManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(RegisterCallback, (::std::int32_t), (::nn::sf::Out<::nn::sf::NativeHandle> registrationEventHandle, ::nn::sf::Out<::std::uint32_t> handleValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(UnregisterCallback, (::std::int32_t), (::std::uint32_t handleValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TriggerSystemEvent, (::std::uint32_t handleValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(PerformAction, (::std::int32_t), (::std::uint32_t action, ::std::uint64_t dataZero, ::std::uint64_t dataOne))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(QueryState, (::std::int32_t), (::std::uint32_t query, ::nn::sf::Out<::std::uint64_t> pDataZero, ::nn::sf::Out<::std::uint64_t> pDataOne))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(OnSystemEvent, (::std::int32_t), (::nn::sf::Out<::std::uint32_t> pEvent, ::nn::sf::Out<::std::uint32_t> pCount, ::nn::sf::Out<::std::uint64_t> pDataZero, ::nn::sf::Out<::std::uint64_t> pDataOne))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(CancelCurrentCall, (::std::int32_t), (::nn::sf::Out<bool> pCallWasCanceled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetHdcpServiceObject, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::hdcp::detail::IHdcpController>> outService))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ICecManager)

        ::std::int32_t RegisterCallback(::nn::sf::Out<::nn::sf::NativeHandle> registrationEventHandle, ::nn::sf::Out<::std::uint32_t> handleValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(RegisterCallback, (::std::int32_t), (registrationEventHandle, handleValue));
        }

        ::std::int32_t UnregisterCallback(::std::uint32_t handleValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(UnregisterCallback, (::std::int32_t), (handleValue));
        }

        ::nn::Result TriggerSystemEvent(::std::uint32_t handleValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TriggerSystemEvent, (handleValue));
        }

        ::std::int32_t PerformAction(::std::uint32_t action, ::std::uint64_t dataZero, ::std::uint64_t dataOne) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(PerformAction, (::std::int32_t), (action, dataZero, dataOne));
        }

        ::std::int32_t QueryState(::std::uint32_t query, ::nn::sf::Out<::std::uint64_t> pDataZero, ::nn::sf::Out<::std::uint64_t> pDataOne) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(QueryState, (::std::int32_t), (query, pDataZero, pDataOne));
        }

        ::std::int32_t OnSystemEvent(::nn::sf::Out<::std::uint32_t> pEvent, ::nn::sf::Out<::std::uint32_t> pCount, ::nn::sf::Out<::std::uint64_t> pDataZero, ::nn::sf::Out<::std::uint64_t> pDataOne) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(OnSystemEvent, (::std::int32_t), (pEvent, pCount, pDataZero, pDataOne));
        }

        ::std::int32_t CancelCurrentCall(::nn::sf::Out<bool> pCallWasCanceled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(CancelCurrentCall, (::std::int32_t), (pCallWasCanceled));
        }

        ::nn::Result GetHdcpServiceObject(::nn::sf::Out<::nn::sf::SharedPointer<::nn::hdcp::detail::IHdcpController>> outService) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetHdcpServiceObject, (outService));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ICecManager
    {
    public:
        std::int32_t RegisterCallback(nn::sf::Out<nn::sf::NativeHandle> registrationEventHandle, nn::sf::Out<std::uint32_t> handleValue) NN_NOEXCEPT;
        std::int32_t UnregisterCallback(std::uint32_t handleValue) NN_NOEXCEPT;
        nn::Result TriggerSystemEvent(std::uint32_t handleValue) NN_NOEXCEPT;
        std::int32_t PerformAction(std::uint32_t action, std::uint64_t dataZero, std::uint64_t dataOne) NN_NOEXCEPT;
        std::int32_t QueryState(std::uint32_t query, nn::sf::Out<std::uint64_t> pDataZero, nn::sf::Out<std::uint64_t> pDataOne) NN_NOEXCEPT;
        std::int32_t OnSystemEvent(nn::sf::Out<std::uint32_t> pEvent, nn::sf::Out<std::uint32_t> pCount, nn::sf::Out<std::uint64_t> pDataZero, nn::sf::Out<std::uint64_t> pDataOne) NN_NOEXCEPT;
        std::int32_t CancelCurrentCall(nn::sf::Out<bool> pCallWasCanceled) NN_NOEXCEPT;
        nn::Result GetHdcpServiceObject(nn::sf::Out<nn::sf::SharedPointer<nn::hdcp::detail::IHdcpController>> outService) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    std::int32_t RegisterCallback(nn::sf::Out<nn::sf::NativeHandle> registrationEventHandle, nn::sf::Out<std::uint32_t> handleValue) NN_NOEXCEPT;
    std::int32_t UnregisterCallback(std::uint32_t handleValue) NN_NOEXCEPT;
    nn::Result TriggerSystemEvent(std::uint32_t handleValue) NN_NOEXCEPT;
    std::int32_t PerformAction(std::uint32_t action, std::uint64_t dataZero, std::uint64_t dataOne) NN_NOEXCEPT;
    std::int32_t QueryState(std::uint32_t query, nn::sf::Out<std::uint64_t> pDataZero, nn::sf::Out<std::uint64_t> pDataOne) NN_NOEXCEPT;
    std::int32_t OnSystemEvent(nn::sf::Out<std::uint32_t> pEvent, nn::sf::Out<std::uint32_t> pCount, nn::sf::Out<std::uint64_t> pDataZero, nn::sf::Out<std::uint64_t> pDataOne) NN_NOEXCEPT;
    std::int32_t CancelCurrentCall(nn::sf::Out<bool> pCallWasCanceled) NN_NOEXCEPT;
    nn::Result GetHdcpServiceObject(nn::sf::Out<nn::sf::SharedPointer<nn::hdcp::detail::IHdcpController>> outService) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::cec::ICecManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(RegisterCallback, (::std::int32_t), (::nn::sf::Out<::nn::sf::NativeHandle> registrationEventHandle, ::nn::sf::Out<::std::uint32_t> handleValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(RegisterCallback, (::std::int32_t), (registrationEventHandle, handleValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(UnregisterCallback, (::std::int32_t), (::std::uint32_t handleValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(UnregisterCallback, (::std::int32_t), (handleValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TriggerSystemEvent, (::std::uint32_t handleValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TriggerSystemEvent, (handleValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(PerformAction, (::std::int32_t), (::std::uint32_t action, ::std::uint64_t dataZero, ::std::uint64_t dataOne))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(PerformAction, (::std::int32_t), (action, dataZero, dataOne));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(QueryState, (::std::int32_t), (::std::uint32_t query, ::nn::sf::Out<::std::uint64_t> pDataZero, ::nn::sf::Out<::std::uint64_t> pDataOne))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(QueryState, (::std::int32_t), (query, pDataZero, pDataOne));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(OnSystemEvent, (::std::int32_t), (::nn::sf::Out<::std::uint32_t> pEvent, ::nn::sf::Out<::std::uint32_t> pCount, ::nn::sf::Out<::std::uint64_t> pDataZero, ::nn::sf::Out<::std::uint64_t> pDataOne))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(OnSystemEvent, (::std::int32_t), (pEvent, pCount, pDataZero, pDataOne));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(CancelCurrentCall, (::std::int32_t), (::nn::sf::Out<bool> pCallWasCanceled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(CancelCurrentCall, (::std::int32_t), (pCallWasCanceled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetHdcpServiceObject, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::hdcp::detail::IHdcpController>> outService))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetHdcpServiceObject, (outService));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::cec::ICecManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::cec::ICecManager))

    // std::int32_t RegisterCallback(nn::sf::Out<nn::sf::NativeHandle> registrationEventHandle, nn::sf::Out<std::uint32_t> handleValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterCallback)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(registrationEventHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (registrationEventHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(handleValue, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (NN_SF_DETAIL_OUT_RETURN_NAME, handleValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(registrationEventHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handleValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterCallback)

    // std::int32_t UnregisterCallback(std::uint32_t handleValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterCallback)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handleValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handleValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handleValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterCallback)

    // nn::Result TriggerSystemEvent(std::uint32_t handleValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TriggerSystemEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handleValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handleValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handleValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TriggerSystemEvent)

    // std::int32_t PerformAction(std::uint32_t action, std::uint64_t dataZero, std::uint64_t dataOne) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PerformAction)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(action, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dataZero, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dataOne, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (action, dataZero, dataOne))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(action), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataZero), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataOne)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PerformAction)

    // std::int32_t QueryState(std::uint32_t query, nn::sf::Out<std::uint64_t> pDataZero, nn::sf::Out<std::uint64_t> pDataOne) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(query, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (query))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pDataZero, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pDataOne, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (NN_SF_DETAIL_OUT_RETURN_NAME, pDataZero, pDataOne))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(query), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pDataZero), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pDataOne)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryState)

    // std::int32_t OnSystemEvent(nn::sf::Out<std::uint32_t> pEvent, nn::sf::Out<std::uint32_t> pCount, nn::sf::Out<std::uint64_t> pDataZero, nn::sf::Out<std::uint64_t> pDataOne) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OnSystemEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pEvent, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pCount, (::std::uint32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pDataZero, (::std::uint64_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pDataOne, (::std::uint64_t), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(5, (NN_SF_DETAIL_OUT_RETURN_NAME, pEvent, pCount, pDataZero, pDataOne))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEvent), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pDataZero), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pDataOne)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OnSystemEvent)

    // std::int32_t CancelCurrentCall(nn::sf::Out<bool> pCallWasCanceled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelCurrentCall)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pCallWasCanceled, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pCallWasCanceled, NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pCallWasCanceled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelCurrentCall)

    // nn::Result GetHdcpServiceObject(nn::sf::Out<nn::sf::SharedPointer<nn::hdcp::detail::IHdcpController>> outService) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetHdcpServiceObject)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outService, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outService))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outService)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetHdcpServiceObject)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::cec::ICecManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::cec::ICecManager))

    // std::int32_t RegisterCallback(nn::sf::Out<nn::sf::NativeHandle> registrationEventHandle, nn::sf::Out<std::uint32_t> handleValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(RegisterCallback, (::std::int32_t), (::nn::sf::Out<::nn::sf::NativeHandle> registrationEventHandle, ::nn::sf::Out<::std::uint32_t> handleValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterCallback)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(registrationEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handleValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterCallback)
    }

    // std::int32_t UnregisterCallback(std::uint32_t handleValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(UnregisterCallback, (::std::int32_t), (::std::uint32_t handleValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterCallback)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handleValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterCallback)
    }

    // nn::Result TriggerSystemEvent(std::uint32_t handleValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TriggerSystemEvent, (::std::uint32_t handleValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TriggerSystemEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handleValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TriggerSystemEvent)
    }

    // std::int32_t PerformAction(std::uint32_t action, std::uint64_t dataZero, std::uint64_t dataOne) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(PerformAction, (::std::int32_t), (::std::uint32_t action, ::std::uint64_t dataZero, ::std::uint64_t dataOne))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PerformAction)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(action)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataZero)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataOne)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PerformAction)
    }

    // std::int32_t QueryState(std::uint32_t query, nn::sf::Out<std::uint64_t> pDataZero, nn::sf::Out<std::uint64_t> pDataOne) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(QueryState, (::std::int32_t), (::std::uint32_t query, ::nn::sf::Out<::std::uint64_t> pDataZero, ::nn::sf::Out<::std::uint64_t> pDataOne))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(query)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pDataZero)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pDataOne)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryState)
    }

    // std::int32_t OnSystemEvent(nn::sf::Out<std::uint32_t> pEvent, nn::sf::Out<std::uint32_t> pCount, nn::sf::Out<std::uint64_t> pDataZero, nn::sf::Out<std::uint64_t> pDataOne) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(OnSystemEvent, (::std::int32_t), (::nn::sf::Out<::std::uint32_t> pEvent, ::nn::sf::Out<::std::uint32_t> pCount, ::nn::sf::Out<::std::uint64_t> pDataZero, ::nn::sf::Out<::std::uint64_t> pDataOne))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OnSystemEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pDataZero)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pDataOne)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OnSystemEvent)
    }

    // std::int32_t CancelCurrentCall(nn::sf::Out<bool> pCallWasCanceled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(CancelCurrentCall, (::std::int32_t), (::nn::sf::Out<bool> pCallWasCanceled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelCurrentCall)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pCallWasCanceled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelCurrentCall)
    }

    // nn::Result GetHdcpServiceObject(nn::sf::Out<nn::sf::SharedPointer<nn::hdcp::detail::IHdcpController>> outService) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetHdcpServiceObject, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::hdcp::detail::IHdcpController>> outService))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetHdcpServiceObject)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outService)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetHdcpServiceObject)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::cec::ICecManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::cec::ICecManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterCallback)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(registrationEventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterCallback)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(registrationEventHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(handleValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterCallback)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterCallback)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handleValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TriggerSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TriggerSystemEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handleValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PerformAction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PerformAction)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(action),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dataZero),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dataOne)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(query),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pDataZero),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pDataOne)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OnSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OnSystemEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pEvent),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pDataZero),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pDataOne)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelCurrentCall)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelCurrentCall)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pCallWasCanceled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetHdcpServiceObject)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::hdcp::detail::IHdcpController>), outService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetHdcpServiceObject)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outService, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterCallback)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterCallback)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TriggerSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PerformAction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OnSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelCurrentCall)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetHdcpServiceObject)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::cec::ICecManager))
