﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace cec {

const int32_t CecNoError                    = 0;

const int32_t CecFsmInvalidArgError         = 0xCECFFFFF;
const int32_t CecFsmInvalidStateError       = 0xCECFFFFE;

const int32_t CecTransmitInvalidArgError    = 0xCECFEFFF;
const int32_t CecTransmitInvalidInitError   = 0xCECFEFFE;
const int32_t CecTransmitCannotSendError    = 0xCECFEFFD;
const int32_t CecTransmitAbortError         = 0xCECFEFFC;
const int32_t CecTransmitNakError           = 0xCECFEFFB;

const int32_t CecReceiveBufferInvalidArgError           = 0xCECFDFFF;
const int32_t CecReceiveBufferInvalidInitError          = 0xCECFDFFE;
const int32_t CecReceiveBufferTimeoutError              = 0xCECFDFFD;
const int32_t CecReceiveBufferNoMemoryError             = 0xCECFDFFC;
const int32_t CecReceiveBufferInvalidDataError          = 0xCECFDFFB;

const int32_t CecTopLevelInvalidArgError            = 0xCECFCFFF;
const int32_t CecTopLevelInvalidInitError           = 0xCECFCFFE;
const int32_t CecTopLevelBusyError                  = 0xCECFCFFD;
const int32_t CecTopLevelNoLogAddrError             = 0xCECFCFFC;
const int32_t CecTopLevelTransmitError              = 0xCECFCFFB;
const int32_t CecTopLevelNoPhysAddrError            = 0xCECFCFFA;
const int32_t CecTopLevelNotInitError               = 0xCECFCFF9;
const int32_t CecTopLevelCachedPhysicalAddressError = 0xCECFCFF8;
const int32_t CecTopLevelMadeUpPhysicalAddressError = 0xCECFCFF7;
const int32_t CecTopLevelInvalidStateError          = 0xCECFCFF6;
const int32_t CecTopLevelNotSupportedError          = 0xCECFCFF5;

const int32_t CecLowLevelInvalidInitError   = 0xCECFBFFF;
const int32_t CecLowLevelNotSupportedError  = 0xCECFBFFE;

const int32_t CecReceiverInvalidInitError   = 0xCECFAFFF;
const int32_t CecReceiverInvalidStateError  = 0xCECFAFFE;
const int32_t CecReceiverHpdChangedError    = 0xCECFAFFD;

const int32_t CecDisplayPortInterfaceInvalidArgError    = 0xCECF9FFF;
const int32_t CecDisplayPortInterfaceInvalidInitError   = 0xCECF9FFE;
const int32_t CecDisplayPortInterfaceNoServiceError     = 0xCECF9FFD;
const int32_t CecDisplayPortInterfaceLowLevelError      = 0xCECF9FFC;
const int32_t CecDisplayPortInterfaceWriteError         = 0xCECF9FFB;
const int32_t CecDisplayPortInterfaceTimeoutError       = 0xCECF9FFA;

const int32_t CecLogAddrInvalidArgError     = 0xCECF8FFF;
const int32_t CecLogAddrInvalidInitError    = 0xCECF8FFE;
const int32_t CecLogAddrInvalidLogAddrError = 0xCECF8FFD;

const int32_t CecManagerImplOperationFailed         = 0xCECF7FFF;
const int32_t CecManagerImplSubsystemDisabled       = 0xCECF7FFE;
const int32_t CecManagerImplSubsystemSuspended      = 0xCECF7FFD;
const int32_t CecManagerImplCommandExecutionFailed  = 0xCECF7FFC;
const int32_t CecManagerImplInvalidOperand          = 0xCECF7FFA;
const int32_t CecManagerImplTimeoutError            = 0xCECF7FF9;
const int32_t CecManagerImplFeatureAbortError       = 0xCECF7FF8;
const int32_t CecManagerImplCancelledError          = 0xCECF7FF7;

}   // namespace cec
}   // namespace nn
