﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace cdhid {
namespace win32 {

enum
{
    MOUSE_THREAD_STACK_SIZE = 16 * 1024,
    MOUSE_DATA_ENTRIES      = 2,
    MOUSE_DATA_SIZE         = 4,
};

class Win32MouseInterface
{
    NN_DISALLOW_COPY(Win32MouseInterface);
    NN_DISALLOW_MOVE(Win32MouseInterface);

public:

    Win32MouseInterface() NN_NOEXCEPT{};
    ~Win32MouseInterface() NN_NOEXCEPT{};

    Result Initialize() NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;

    Result AcquireDevice() NN_NOEXCEPT;
    Result ReleaseDevice() NN_NOEXCEPT;
    Result SetCtrlSession(nn::sf::SharedPointer<nn::ahid::ICtrlSession> pCtrlSession) NN_NOEXCEPT;

    Result AhidGetCodeBook(uint8_t* pBuffer, uint32_t bufferSize) NN_NOEXCEPT;
    Result AhidRead(uint32_t* pBytesTransferred, uint8_t* pBuffer, uint32_t bytes, nn::TimeSpan timeout) NN_NOEXCEPT;

        // runtime mouse params
    bool                            m_LeftButton;
    bool                            m_CenterButton;
    bool                            m_RightButton;
    bool                            m_4thButton;
    bool                            m_5thButton;

private:

    bool                            m_IsAcquired;
    nn::ahid::hdr::Hdr              m_Hdr;
    nn::ahid::hdr::DeviceHandle     m_HdrDeviceHandle;
    Win32MouseBuffer                m_Buffer;
    Win32MouseCodeBook              m_CodeBook;
    uint8_t                         m_MouseData[MOUSE_DATA_ENTRIES][MOUSE_DATA_SIZE];
    nn::sf::SharedPointer<nn::ahid::ICtrlSession>  m_CtrlSession;

    Result AttachDevice() NN_NOEXCEPT;
    Result DetachDevice() NN_NOEXCEPT;

    // Read thread to get Windows mouse events
    nn::os::ThreadType              m_ReadThread;
    NN_ALIGNAS(4096) uint8_t        m_ReadThreadStack[MOUSE_THREAD_STACK_SIZE];

    void ReadFromMouse();

    static void ThreadFunction(void* pThis)
    {
        reinterpret_cast<Win32MouseInterface*>(pThis)->ReadFromMouse();
    }

    HWND                            m_Hwnd;
};

} // end of namespace win32
} // end of namespace cdhid
} // end of namespace nn
