﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "cdhidWin32Mouse_Private.h"

namespace nn {
namespace cdhid {
namespace win32 {

//////////////////////////////////////////////////////////////////////////////
CtrlSession::CtrlSession(Win32MouseInterface *pWin32MouseInterface, uint32_t deviceHandle) NN_NOEXCEPT
: m_StateChangeEvent(nn::os::EventClearMode_AutoClear, true)
{
    m_pWin32MouseInterface  = pWin32MouseInterface;
    m_DeviceHandle          = deviceHandle;
}


//////////////////////////////////////////////////////////////////////////////
CtrlSession::~CtrlSession() NN_NOEXCEPT
{
}


//////////////////////////////////////////////////////////////////////////////
Result CtrlSession::GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT
{
    eventHandle.Set(nn::sf::NativeHandle(m_StateChangeEvent.GetReadableHandle(), false));
    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result CtrlSession::SignalStateChangeEvent() NN_NOEXCEPT
{
    m_StateChangeEvent.Signal();
    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result CtrlSession::GetString(uint32_t stringIndex, nn::sf::OutBuffer outBuffer) NN_NOEXCEPT
{
    NN_UNUSED(stringIndex);
    NN_UNUSED(outBuffer);

    return nn::ahid::ResultFunctionNotSupported();
}


//////////////////////////////////////////////////////////////////////////////
Result CtrlSession::GetReport(uint32_t reportType, uint32_t reportId, nn::sf::OutBuffer outBuffer) NN_NOEXCEPT
{
    NN_UNUSED(reportType);
    NN_UNUSED(reportId);
    NN_UNUSED(outBuffer);

    return nn::ahid::ResultFunctionNotSupported();
}


//////////////////////////////////////////////////////////////////////////////
Result CtrlSession::SetReport(uint32_t reportType, uint32_t reportId, nn::sf::InBuffer inBuffer) NN_NOEXCEPT
{
    NN_UNUSED(reportType);
    NN_UNUSED(reportId);
    NN_UNUSED(inBuffer);

    return nn::ahid::ResultFunctionNotSupported();
}


//////////////////////////////////////////////////////////////////////////////
Result CtrlSession::GetIdle(nn::sf::OutBuffer outBuffer, uint8_t reportId) NN_NOEXCEPT
{
    NN_UNUSED(reportId);
    NN_UNUSED(outBuffer);

    return nn::ahid::ResultFunctionNotSupported();
}


//////////////////////////////////////////////////////////////////////////////
Result CtrlSession::SetIdle(uint8_t idle, uint8_t reportId) NN_NOEXCEPT
{
    NN_UNUSED(idle);
    NN_UNUSED(reportId);

    return nn::ahid::ResultFunctionNotSupported();
}


//////////////////////////////////////////////////////////////////////////////
Result CtrlSession::GetProtocol(nn::sf::OutBuffer outBuffer) NN_NOEXCEPT
{
    NN_UNUSED(outBuffer);

    return nn::ahid::ResultFunctionNotSupported();
}


//////////////////////////////////////////////////////////////////////////////
Result CtrlSession::SetProtocol(uint8_t protocol) NN_NOEXCEPT
{
    NN_UNUSED(protocol);

    return nn::ahid::ResultFunctionNotSupported();
}


//////////////////////////////////////////////////////////////////////////////
Result CtrlSession::GetDescriptor(nn::sf::OutBuffer outBuffer, uint8_t bmRequestType, uint16_t wValue, uint16_t wIndex) NN_NOEXCEPT
{
    NN_UNUSED(outBuffer);
    NN_UNUSED(bmRequestType);
    NN_UNUSED(wValue);
    NN_UNUSED(wIndex);

    return nn::ahid::ResultFunctionNotSupported();
}


//////////////////////////////////////////////////////////////////////////////
Result CtrlSession::SetDescriptor(nn::sf::InBuffer inBuffer, uint8_t bmRequestType, uint16_t wValue, uint16_t wIndex) NN_NOEXCEPT
{
    NN_UNUSED(inBuffer);
    NN_UNUSED(bmRequestType);
    NN_UNUSED(wValue);
    NN_UNUSED(wIndex);

    return nn::ahid::ResultFunctionNotSupported();
}


//////////////////////////////////////////////////////////////////////////////
Result CtrlSession::GetCodeBook(nn::sf::OutBuffer outBuffer) NN_NOEXCEPT
{
    return m_pWin32MouseInterface->AhidGetCodeBook(
                                        reinterpret_cast<uint8_t *>(outBuffer.GetPointerUnsafe()),
                                        static_cast<uint32_t>(outBuffer.GetSize())
                                        );
}


//////////////////////////////////////////////////////////////////////////////
Result CtrlSession::Write(nn::sf::InBuffer inBuffer, nn::sf::Out<std::uint32_t> pBytesWritten, nn::TimeSpan timeout) NN_NOEXCEPT
{
    NN_UNUSED(inBuffer);
    NN_UNUSED(timeout);

    *pBytesWritten = 0;

    return nn::ahid::ResultFunctionNotSupported();
}


} // end of namespace win32
} // end of namespace cdhid
} // end of namespace nn
