﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "cdhidWin32Keyboard_Private.h"

#include <nn/nn_Common.h>
#include <nn/sf/sf_HipcServer.h>
#include <type_traits>
#include <new>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SystemThreadDefinition.h>

namespace nn {
namespace cdhid {
namespace win32 {

//////////////////////////////////////////////////////////////////////////////
//  public functions
//////////////////////////////////////////////////////////////////////////////
Result Win32KeyboardServer::Initialize() NN_NOEXCEPT
{
    Result result = InitializePort(0, 1, "Keyboar");

    if (result.IsSuccess())
    {
        m_HeapHandle = nn::lmem::CreateExpHeap(
                                                &m_SfHeapBuffer,
                                                sizeof(m_SfHeapBuffer),
                                                nn::lmem::CreationOption_NoOption
                                                );
        m_SfAllocator.Attach(m_HeapHandle);

        Start();

        nn::os::CreateThread(
            &m_Thread,
            SessionThread,
            this,
            m_ThreadStack,
            WIN32KEYBOARD_SERVER_STACK_SIZE,
            NN_SYSTEM_THREAD_PRIORITY(cdhid,Win32KeyboardIpcServer)
            );

        nn::os::SetThreadNamePointer(&m_Thread, NN_SYSTEM_THREAD_NAME(cdhid, Win32KeyboardIpcServer));
        nn::os::StartThread(&m_Thread);

        m_Win32KeyboardInterface.Initialize();
    }

    return result;
}


//////////////////////////////////////////////////////////////////////////////
Result Win32KeyboardServer::Finalize() NN_NOEXCEPT
{
    m_Win32KeyboardInterface.Finalize();

    RequestStop();

    nn::os::WaitThread(&m_Thread);
    nn::os::DestroyThread(&m_Thread);

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
//  private functions
//////////////////////////////////////////////////////////////////////////////
Result Win32KeyboardServer::OnNeedsToAccept(int portIndex, PortObjectImpl* pPort) NN_NOEXCEPT
{
    NN_UNUSED(portIndex);

    typedef nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy> Factory;

    return AcceptImpl(
                    pPort,
                    Factory::CreateSharedEmplaced<nn::ahid::IServerSession, ServerSession>(&m_SfAllocator, &m_Win32KeyboardInterface, &m_SfAllocator)
                    );
}


//////////////////////////////////////////////////////////////////////////////
void Win32KeyboardServer::SessionThread(void *arg) NN_NOEXCEPT
{
    Win32KeyboardServer *pThis = reinterpret_cast<Win32KeyboardServer*>(arg);
    pThis->LoopAuto();
}



} // end of namespace win32
} // end of namespace cdhid
} // end of namespace nn
