﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace cdhid {
namespace win32 {

class Win32KeyboardInterface;

class ReadSession
{

public:

    NN_IMPLICIT  ReadSession(Win32KeyboardInterface *pWin32KeyboardInterface, uint32_t deviceHandle) NN_NOEXCEPT;
    NN_IMPLICIT ~ReadSession() NN_NOEXCEPT;

    Result Read(nn::sf::OutBuffer outBuffer, nn::sf::Out<std::uint32_t> pBytesRead, nn::TimeSpan timeout) NN_NOEXCEPT;

private:

    Win32KeyboardInterface*    m_pWin32KeyboardInterface;
    uint32_t                m_DeviceHandle;
};

} // end of namespace win32
} // end of namespace cdhid
} // end of namespace nn
