﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace cdhid {
namespace win32 {

typedef nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy> Factory;

class ServerSession : public nn::sf::ISharedObject
{

public:

    NN_IMPLICIT  ServerSession(Win32HidEnum *pWin32HidEnum, nn::sf::ExpHeapAllocator *pAllocator) NN_NOEXCEPT;
    NN_IMPLICIT ~ServerSession() NN_NOEXCEPT;

    Result AcquireDevice(uint32_t deviceHandle) NN_NOEXCEPT;
    Result ReleaseDevice(uint32_t deviceHandle) NN_NOEXCEPT;
    Result GetCtrlSession(uint32_t deviceHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ahid::ICtrlSession>> outCtrlSession) NN_NOEXCEPT;
    Result GetReadSession(uint32_t deviceHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ahid::IReadSession>> outReadSession) NN_NOEXCEPT;

private:

    Win32HidEnum*               m_pWin32HidEnum;
    Win32HidInterface*          m_pWin32HidInterface;
    nn::sf::ExpHeapAllocator*   m_pAllocator;
};

} // end of namespace win32
} // end of namespace cdhid
} // end of namespace nn
