﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace cdhid {
namespace win32 {

class Win32HidInterface;

class ReadSession
{

public:

    NN_IMPLICIT  ReadSession(Win32HidInterface *pWin32HidInterface, uint32_t deviceHandle) NN_NOEXCEPT;
    NN_IMPLICIT ~ReadSession() NN_NOEXCEPT;

    Result Read(nn::sf::OutBuffer outBuffer, nn::sf::Out<std::uint32_t> pBytesRead, nn::TimeSpan timeout) NN_NOEXCEPT;

private:

    Win32HidInterface*  m_pWin32HidInterface;
    uint32_t            m_DeviceHandle;
};

}   // namespace win32
}   // namespace cdhid
}   // namespace nn
