﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace cdhid {
namespace win32 {

enum
{
    WIN32_HID_DATA_BUFFER_SIZE  = 512,
    WIN32_HID_MAX_DEVICES       = (nn::ahid::hdr::AhidDevicesCountMax - 2),   // Win32Mouse, Win32Keyboard AHID will publish 1 device each
};

class Win32HidEnum
{

    NN_DISALLOW_COPY(Win32HidEnum);
    NN_DISALLOW_MOVE(Win32HidEnum);

public:

    Win32HidEnum() NN_NOEXCEPT {};
    ~Win32HidEnum() NN_NOEXCEPT {};

    Result Initialize() NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;

    Result AcquireDevice(uint32_t deviceHandle, Win32HidInterface **ppWin32HidInterface) NN_NOEXCEPT;
    Result ReleaseDevice(uint32_t deviceHandle) NN_NOEXCEPT;

private:

    nn::ahid::hdr::Hdr              m_Hdr;
    Win32HidInterface               m_Win32HidInterface[WIN32_HID_MAX_DEVICES];
    bool                            m_Run;
    BYTE                            m_DataBuffer[WIN32_HID_DATA_BUFFER_SIZE];

    nn::os::ThreadType              m_Thread;
    NN_ALIGNAS(4096) uint8_t        m_ThreadStack[64 * 1024];

    void ServiceLoop() NN_NOEXCEPT;

    static void ThreadFunction(void* pThis) NN_NOEXCEPT
    {
        reinterpret_cast<Win32HidEnum*>(pThis)->ServiceLoop();
    }

    void EnumerateDevices() NN_NOEXCEPT;
    bool IsAlreadyAttached(SP_DEVINFO_DATA* pDeviceInfoData) NN_NOEXCEPT;
    void AttachDevice(SP_DEVINFO_DATA* pDeviceInfoData, WCHAR* pDevicePath);
    void DetachDevice(int index);
    uint8_t CopyWideString(uint16_t* pDst, uint16_t* pSrc) NN_NOEXCEPT;
    Result GetInterfaceIndex(int deviceHandle, int *pIndex) NN_NOEXCEPT;

};

} // end of namespace win32
} // end of namespace cdhid
} // end of namespace nn
