﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/ahid/sfdl/IServerSession.sfdl.h>

/**
 * @file    cdhidUsb_Main.h
 * @brief   USB HID AHID Server Top Level
 */

namespace nn {
namespace cdhid {
namespace usb {

Result UsbHidInitialize() NN_NOEXCEPT;
Result UsbHidFinalize() NN_NOEXCEPT;
nn::sf::SharedPointer<nn::ahid::IServerSession> UsbHidGetDfcSession() NN_NOEXCEPT;

} // end of namespace usb
} // end of namespace cdhid
} // end of namespace nn
