﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace cdhid {
namespace usb {

class UsbHidInterface;

class CtrlSession
{

public:

    NN_IMPLICIT  CtrlSession(UsbHidInterface *pUsbHidInterface, uint32_t deviceHandle) NN_NOEXCEPT;
    NN_IMPLICIT ~CtrlSession() NN_NOEXCEPT;

    Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle ) NN_NOEXCEPT;
    Result SignalStateChangeEvent() NN_NOEXCEPT;
    Result GetString(uint32_t stringIndex, nn::sf::OutBuffer outBuffer)NN_NOEXCEPT;
    Result GetCodeBook(nn::sf::OutBuffer outBuffer) NN_NOEXCEPT;

    Result GetReport(uint32_t reportType, uint32_t reportId, nn::sf::OutBuffer outBuffer) NN_NOEXCEPT;
    Result SetReport(uint32_t reportType, uint32_t reportId, nn::sf::InBuffer inBuffer) NN_NOEXCEPT;
    Result GetIdle(nn::sf::OutBuffer outBuffer, uint8_t reportId) NN_NOEXCEPT;
    Result SetIdle(uint8_t idle, uint8_t reportId) NN_NOEXCEPT;
    Result GetProtocol(nn::sf::OutBuffer outBuffer) NN_NOEXCEPT;
    Result SetProtocol(uint8_t protocol) NN_NOEXCEPT;
    Result GetDescriptor(nn::sf::OutBuffer outBuffer, uint8_t bmRequestType, uint16_t wValue, uint16_t wIndex) NN_NOEXCEPT;
    Result SetDescriptor(nn::sf::InBuffer inBuffer, uint8_t bmRequestType, uint16_t wValue, uint16_t wIndex) NN_NOEXCEPT;
    Result Write(nn::sf::InBuffer inBuffer, nn::sf::Out<std::uint32_t> pBytesWritten, nn::TimeSpan timeout) NN_NOEXCEPT;

private:

    UsbHidInterface    *m_pUsbHidInterface;
    uint32_t            m_DeviceHandle;
    nn::os::SystemEvent m_StateChangeEvent;
};

} // end of namespace usb
} // end of namespace cdhid
} // end of namespace nn
