﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file  cdacm_Utils.h
 * @brief Helper utilities
 *
 * @details
 */

#pragma once

#include <list>
#include <memory>
#include <type_traits>

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>

#include <nn/dd/dd_DeviceAddressSpaceCommon.h>

#include <nn/cdacm/cdacm_Types.h>

#if defined(NN_BUILD_CONFIG_COMPILER_GCC)   || \
    defined(NN_BUILD_CONFIG_COMPILER_CLANG) || \
    defined(NN_BUILD_CONFIG_COMPILER_GHS)   || \
    defined(NN_BUILD_CONFIG_COMPILER_OASIS_CAFE_CLANG)

    #define NN_CDACM_PACKED_ALIGNED(alignment)              \
        __attribute__((__packed__,__aligned__(alignment)))
    #define NN_CDACM_PACKED                                 \
        __attribute__((__packed__))

#else // VC

    #define NN_CDACM_PACKED_ALIGNED(alignment)
    #define NN_CDACM_PACKED()

#endif

#define NN_CDACM_ABORT(format,...)              \
    NN_ABORT("abort: " format, ##__VA_ARGS__)
#define NN_CDACM_ABORT_UNLESS_SUCCESS(result)                                            \
    NN_ABORT_UNLESS((result).IsSuccess())
#define NN_CDACM_ABORT_IF_NULL(pointerVal)                                               \
    NN_ABORT_UNLESS_NOT_NULL(pointerVal)

#define NN_CDACM_ABORT_UNLESS(condition)                                                 \
    if (!(condition))                                                                    \
    {                                                                                    \
        NN_CDACM_ABORT("condition %s false in func-%s @ line-%d.\n",                     \
                     #condition,__FUNCTION__,__LINE__);                                  \
    }

#define NN_CDACM_ABORT_UPON_ERROR(attemptedMethodCall)                                   \
    if (!((result=(attemptedMethodCall)).IsSuccess()))                                   \
    {                                                                                    \
        NN_CDACM_ABORT("%s unsuccessful %d:%d in func-%s @ line-%d.\n",                  \
                     #attemptedMethodCall,result.GetModule(),                            \
                     result.GetDescription(),__FUNCTION__,__LINE__);                     \
    }

#define NN_CDACM_DO(action)                                                              \
    do {                                                                                 \
        result = action;                                                                 \
        if (result.IsFailure())                                                          \
        {                                                                                \
            NN_CDACM_WARN("%s failed with %d:%d in func-%s @ line-%d.\n",                \
                          #action, result.GetModule(), result.GetDescription(),          \
                          __FUNCTION__,__LINE__);                                        \
        }                                                                                \
    } while(0)


#define BmRequestType(type, recip, dir)                                                  \
    (nn::usb::UsbCtrlXferReqTypeMask_Type##type   |                                      \
     nn::usb::UsbCtrlXferReqTypeMask_Recip##recip |                                      \
     nn::usb::UsbCtrlXferReqTypeMask_Dir##dir     )

namespace nn {
namespace cdacm {

void ShiftBuffer(void *buffer, uint32_t length, uint32_t bytesToShift) NN_NOEXCEPT;

} // end of namespace cdacm
} // end of namespace nn


