﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_SdkLog.h>
#include <nn/util/util_FormatString.h>

#include "cdacm_Log.h"
#include "cdacm_Utils.h"

namespace nn {
namespace cdacm {

/*
* ShiftBuffer
*
* @brief Shift data in buffer (not expected to be many bytes).
*/
void
ShiftBuffer(void *buffer, uint32_t length, uint32_t bytesToShift) NN_NOEXCEPT
{
    uint8_t * pBytes = reinterpret_cast<uint8_t*>(buffer);

    for (uint32_t i = 0; i < length - bytesToShift; i++)
    {
        *(pBytes + i) = *(pBytes + i + bytesToShift);
    }
}

} // end of namespace cdacm
} // end of namespace nn
