﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file       cdacm_Log.h
    @brief      cdacm Logging API.
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

namespace nn {
namespace cdacm {


extern bool g_LogObserverEnabled;

#define NN_CDACM_INFO(...)   do { if (g_LogObserverEnabled == false) NN_DETAIL_STRUCTURED_SDK_LOG(cdacm, Info,  0, ##__VA_ARGS__); } while(false)
#define NN_CDACM_WARN(...)   do { if (g_LogObserverEnabled == false) NN_DETAIL_STRUCTURED_SDK_LOG(cdacm, Warn,  0, ##__VA_ARGS__); } while(false)
#define NN_CDACM_ERROR(...)  do { if (g_LogObserverEnabled == false) NN_DETAIL_STRUCTURED_SDK_LOG(cdacm, Error, 0, ##__VA_ARGS__); } while(false)

}
}
