﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <algorithm>
#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/fs.h>
#include <nn/result/result_HandlingUtility.h>

#include "cal_FileSystem.h"
#include "cal_Settings.h"

namespace nn { namespace cal {

::nn::Result GetCalibrationInfo(CalibrationInfo* outValue) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outValue);

    RawPartition rawPartition;
    NN_RESULT_DO(rawPartition.Mount());

    CalibrationFile calibrationFile;
    NN_RESULT_DO(calibrationFile.Open());

    ::std::unique_ptr<CalibrationInfo> calibrationInfo(new CalibrationInfo());
    *outValue = *calibrationInfo;

    NN_RESULT_DO(calibrationFile.Read(outValue, sizeof(CalibrationInfo)));

    NN_RESULT_SUCCESS;
}

::nn::Result SetCalibrationInfo(const CalibrationInfo& value) NN_NOEXCEPT
{
    RawPartition rawPartition;
    NN_RESULT_DO(rawPartition.Mount());

    CalibrationFile calibrationFile;
    NN_RESULT_DO(calibrationFile.Open());

    NN_RESULT_DO(calibrationFile.Write(&value, sizeof(CalibrationInfo)));

    NN_RESULT_SUCCESS;
}

}}
