﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/i2c/i2c.h>

#include "bpc_RtcAccessor-hardware.nx.h"

namespace
{
bool HasDevice(nn::i2c::I2cSession* pSession)
{
    // 定数が返ってくるレジスタはなさそうなので、読んで害のなさそうな RTCYEAR を読む
    // 値の整合性はチェックしない
    const nn::Bit8 RtcyearRegisterAddress = 0x0c;
    nn::Bit8 rtcyear;
    auto result = nn::i2c::ReadSingleRegister(&rtcyear, *pSession, &RtcyearRegisterAddress);
    return result.IsSuccess();
}
}

namespace nn { namespace bpc { namespace driver { namespace detail {

nn::i2c::I2cSession* GetRtcI2cSession() NN_NOEXCEPT
{
    static nn::i2c::I2cSession s_Session;
    static bool s_IsSessionOpen = false;
    if (!s_IsSessionOpen)
    {
        s_IsSessionOpen = true;
        // open session
        nn::i2c::Initialize();
        nn::i2c::OpenSession(&s_Session, nn::i2c::I2cDevice_Max77620Rtc);

        NN_ABORT_UNLESS(HasDevice(&s_Session));
    }
    return &s_Session;
}

}}}} // namespace nn::bpc::driver::detail
