﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_HipcClientProxyByName.h> // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h> // for nn::sf::ExpHeapStaticAllocator
#include <nn/nn_Abort.h>

#include <nn/bpc/bpc_IBoardPowerControlManager.sfdl.h>
#include <nn/bpc/bpc_IRtcManager.sfdl.h>
#include <nn/bpc/bpc_ServiceName.h>

#include "bpc_GetManagerByHipc.h"

namespace nn { namespace bpc {

namespace {

// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct CreateBpcManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateBpcManagerByHipcTag> MyAllocator;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_MyAllocatorInitializer;

} // namespace

nn::sf::SharedPointer<nn::bpc::IBoardPowerControlManager> GetBoardPowerControlManagerByHipc() NN_NOEXCEPT
{
    // BoardPowerControlServiceName のサービス名で示される HIPC サービスオブジェクトを、
    // IBoardPowerControlManager としてプロキシクライアントを作成して返す。
    // アロケーションポリシーとして MyAllocator::Policy を渡している。
    nn::sf::SharedPointer<nn::bpc::IBoardPowerControlManager> manager;
    auto result = nn::sf::CreateHipcProxyByName<nn::bpc::IBoardPowerControlManager, MyAllocator::Policy>(&manager, nn::bpc::BoardPowerControlServiceName);

    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return manager;
}

nn::sf::SharedPointer<nn::bpc::IRtcManager> GetRtcManagerByHipc() NN_NOEXCEPT
{
    // RtcServiceName のサービス名で示される HIPC サービスオブジェクトを、
    // IRtcManager としてプロキシクライアントを作成して返す。
    // アロケーションポリシーとして MyAllocator::Policy を渡している。
    nn::sf::SharedPointer<nn::bpc::IRtcManager> manager;
    auto result = nn::sf::CreateHipcProxyByName<nn::bpc::IRtcManager, MyAllocator::Policy>(&manager, nn::bpc::RtcServiceName);

    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return manager;
}

}} // namespace nn::bpc
