﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using Nintendo.ServiceFramework.Applet;

namespace nn.settings.system
{
    [CppRefPath(@"<nn/settings/system/settings_BluetoothDevices.h>")]
    [ExternalStruct(512, 4)]
    [LargeData(true)]
    public struct BluetoothDevicesSettings
    {
    }
}

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nn.bluetooth
{
    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(6, 1)]
    public struct BluetoothAddress
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(3, 1)]
    public struct ClassOfDevice
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(259, 1)]
    [LargeData(true)]
    public struct AdapterProperty
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(16, 1)]
    public struct BluetoothPinCode
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(642, 2)]
    [LargeData(true)]
    public struct HidData
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct BluetoothPropertyType
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(4, 4)]
    public struct BluetoothHhReportType
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(11, 1)]
    [LargeData(true)]
    public struct ChannelInfo
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(4, 4)]
    [LargeData(true)]
    public struct BluetoothTransport
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(132, 4)]
    [LargeData(true)]
    public struct PlrStatistics
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(136, 1)]
    [LargeData(true)]
    public struct ChannelMap
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(20, 4)]
    public struct GattAttributeUuid
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(24, 4)]
    public struct GattId
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(204, 4)]
    [LargeData(true)]
    public struct LeAdvertiseData
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(20, 2)]
    public struct LeConnectionParams
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(1, 1)]
    public struct BleAdType
    {

    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(33, 1)]
    public struct BleAdStructure
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_Types.h>")]
    [ExternalStruct(62, 1)]
    [LargeData(true)]
    public struct BleAdvertiseFilter
    {
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_IBluetoothDriver.sfdl.h>")]
    public interface IBluetoothDriver : IServiceObject
    {
        [MethodId(0)]
        Result WaitServerReady();
        [MethodId(1)]
        Result InitializeBluetoothImpl(Out<NativeHandle> handle);
        [MethodId(2)]
        Result EnableBluetoothImpl();
        [MethodId(3)]
        Result DisableBluetoothImpl();
        [MethodId(4)]
        Result CleanupBluetoothImpl();
        [MethodId(5)]
        Result GetAdapterPropertiesImpl(Out<AdapterProperty> pAdapterProperty);
        [MethodId(6)]
        Result GetAdapterPropertyImpl(BluetoothPropertyType propertyType, OutArray<uint8_t> pOutArray);
        [MethodId(7)]
        Result SetAdapterPropertyImpl(BluetoothPropertyType propertyType, InArray<uint8_t> pInArray);
        [MethodId(8)]
        Result StartDiscoveryImpl();
        [MethodId(9)]
        Result CancelDiscoveryImpl();
        [MethodId(10)]
        Result CreateBondImpl(BluetoothAddress bluetoothAddress, BluetoothTransport transport);
        [MethodId(11)]
        Result RemoveBondImpl(BluetoothAddress bluetoothAddress);
        [MethodId(12)]
        Result CancelBondImpl(BluetoothAddress bluetoothAddress);
        [MethodId(13)]
        Result PinReplyImpl(BluetoothAddress bluetoothAddress, uint8_t accept, uint8_t pinLength, BluetoothPinCode pinCode);
        [MethodId(14)]
        Result SspReplyImpl(BluetoothAddress bluetoothAddress, uint8_t variant, uint8_t accept, uint32_t passkey);

        [MethodId(15)]
        Result GetEventInfoImpl(Out<uint32_t> pEventType, OutArray<uint8_t> pOutArray);

        [MethodId(16)]
        Result InitializeHidImpl(Out<NativeHandle> handle, uint16_t version);
        [MethodId(17)]
        Result HidConnectImpl(BluetoothAddress bluetoothAddress);
        [MethodId(18)]
        Result HidDisconnectImpl(BluetoothAddress bluetoothAddress);
        [MethodId(19)]
        Result HidSendDataByStructureImpl(BluetoothAddress bluetoothAddress, HidData pData);
        [MethodId(20)]
        Result HidSendDataImpl(BluetoothAddress bluetoothAddress, InArray<uint8_t> pInArray);
        [MethodId(21)]
        Result HidSetReportImpl(BluetoothAddress bluetoothAddress, BluetoothHhReportType reportType, HidData pData);
        [MethodId(22)]
        Result HidGetReportImpl(BluetoothAddress bluetoothAddress, BluetoothHhReportType reportType, uint8_t reportId);
        [MethodId(23)]
        Result HidWakeControllerImpl(BluetoothAddress bluetoothAddress);
        [MethodId(24)]
        Result HidAddPairedDeviceImpl(nn.settings.system.BluetoothDevicesSettings deviceSettings);
        [MethodId(25)]
        Result HidGetPairedDeviceImpl(BluetoothAddress bluetoothAddress, Out<nn.settings.system.BluetoothDevicesSettings> deviceSettings);

        [MethodId(26)]
        Result CleanupHidImpl();

        [MethodId(27)]
        Result HidGetEventInfoImpl(Out<uint32_t> pEventType, OutArray<uint8_t> pOutArray);

        [MethodId(28)]
        Result ExtSetTsiImpl(BluetoothAddress bluetoothAddress, uint8_t tsiMode);
        [MethodId(29)]
        Result ExtSetBurstModeImpl(BluetoothAddress bluetoothAddress, bool isBurst);
        [MethodId(30)]
        Result ExtSetZeroRetranImpl(BluetoothAddress bluetoothAddress, InArray<uint8_t> pReportIds);
        [MethodId(31)]
        Result ExtSetMcModeImpl(bool isMcModeEnabled);
        [MethodId(32)]
        Result ExtStartLlrModeImpl();
        [MethodId(33)]
        Result ExtExitLlrModeImpl();
        [MethodId(34)]
        Result ExtSetRadioImpl(bool enable);
        [MethodId(35)]
        Result ExtSetVisibilityImpl(bool discoverable, bool connectable);
        [MethodId(36)]
        Result ExtSetTbfcScanImpl(bool enable);

        [MethodId(37)]
        Result RegisterHidReportEventImpl(Out<NativeHandle> handle);
        [MethodId(38)]
        Result HidGetReportEventInfoImpl(Out<uint32_t> pEventType, OutArray<uint8_t> pOutArray);

        [MethodId(39)]
        Result GetLatestPlrImpl([BufferTransferMode(BufferTransferMode.MapAlias)] Out<PlrStatistics> pOut);

        [MethodId(40)]
        Result ExtGetPendingConnectionsImpl();

        [MethodId(41)]
        Result GetChannelMapImpl([BufferTransferMode(BufferTransferMode.MapAlias)] Out<ChannelMap> pOutChannelMap);

        [MethodId(42)]
        Result EnableBluetoothBoostSettingImpl(bool enable);
        [MethodId(43)]
        Result IsBluetoothBoostEnabledImpl(Out<bool> pOut);
        [MethodId(44)]
        Result EnableBluetoothAfhSettingImpl(bool enable);
        [MethodId(45)]
        Result IsBluetoothAfhEnabledImpl(Out<bool> pOut);
        [MethodId(46)]
        Result InitializeBleImpl(Out<NativeHandle> handle);
        [MethodId(47)]
        Result EnableBleImpl();
        [MethodId(48)]
        Result DisableBleImpl();
        [MethodId(49)]
        Result CleanupBleImpl();
        [MethodId(50)]
        Result SetLeVisibilityImpl(bool discoverable, bool connectable);
        [MethodId(51)]
        Result SetLeConnectionParameterImpl(LeConnectionParams connectionParams);
        [MethodId(52)]
        Result SetLeDefaultConnectionParameterImpl(LeConnectionParams connectionParams);
        [MethodId(53)]
        Result SetLeAdvertiseDataImpl(LeAdvertiseData advertiseData);
        [MethodId(54)]
        Result SetLeAdvertiseParameterImpl(BluetoothAddress bluetoothAddress, uint16_t minAdvInt, uint16_t maxAdvInt);
        [MethodId(55)]
        Result StartLeScanImpl();
        [MethodId(56)]
        Result StopLeScanImpl();
        [MethodId(57)]
        Result AddLeScanFilterConditionImpl(BleAdvertiseFilter filter);
        [MethodId(58)]
        Result DeleteLeScanFilterConditionImpl(BleAdvertiseFilter filter);
        [MethodId(59)]
        Result DeleteLeScanFilterImpl(uint8_t filterIndex);
        [MethodId(60)]
        Result ClearLeScanFiltersImpl();
        [MethodId(61)]
        Result EnableLeScanFilterImpl(bool enable);
        [MethodId(62)]
        Result RegisterLeClientImpl(GattAttributeUuid uuid);
        [MethodId(63)]
        Result UnregisterLeClientImpl(uint8_t clientIf);
        [MethodId(64)]
        Result UnregisterLeClientAllImpl();
        [MethodId(65)]
        Result LeClientConnectImpl(
            nn.applet.AppletResourceUserId aruid,
            uint8_t clientIf, BluetoothAddress bluetoothAddress, bool isDirect);
        [MethodId(66)]
        Result LeClientCancelConnectionImpl(uint8_t clientIf, BluetoothAddress bluetoothAddress, bool isDirect);
        [MethodId(67)]
        Result LeClientDisconnectImpl(uint32_t connId);
        [MethodId(68)]
        Result LeClientGetAttributesImpl(uint32_t connId, BluetoothAddress bluetoothAddress);
        [MethodId(69)]
        Result LeClientDiscoverServiceImpl(uint32_t connId, GattAttributeUuid filterUuid);
        [MethodId(70)]
        Result LeClientConfigureMtu(uint32_t connId, uint16_t mtu);
        [MethodId(71)]
        Result RegisterLeServerImpl(GattAttributeUuid uuid);
        [MethodId(72)]
        Result UnregisterLeServerImpl(uint8_t serverIf);
        [MethodId(73)]
        Result LeServerConnectImpl(uint8_t serverIf, BluetoothAddress bluetoothAddress, bool isDirect);
        [MethodId(74)]
        Result LeServerDisconnectImpl(uint8_t serverIf, BluetoothAddress bluetoothAddress);
        [MethodId(75)]
        Result CreateLeServiceImpl(uint8_t serverIf, GattAttributeUuid uuid, uint8_t handleNum, bool isPrimaryService);
        [MethodId(76)]
        Result StartLeServiceImpl(uint8_t serverIf, GattAttributeUuid uuid);
        [MethodId(77)]
        Result AddLeCharacteristicImpl(uint8_t serverIf, GattAttributeUuid serviceUuid, GattAttributeUuid charUuid, uint16_t permissions, uint8_t properties);
        [MethodId(78)]
        Result AddLeDescriptorImpl(uint8_t serverIf, GattAttributeUuid serviceUuid, GattAttributeUuid descUuid, uint16_t permissions);
        [MethodId(79)]
        Result GetLeCoreEventInfoImpl(Out<uint32_t> pEventType, OutArray<uint8_t> pOutArray);
        [MethodId(80)]
        Result LeGetFirstCharacteristicImpl(Out<GattId> charOut, Out<uint8_t> property, uint32_t connId, GattId serviceId, bool isPrimary, GattAttributeUuid charFilter);
        [MethodId(81)]
        Result LeGetNextCharacteristicImpl(Out<GattId> charOut, Out<uint8_t> property, uint32_t connId, GattId serviceId, bool isPrimary, GattId charIn, GattAttributeUuid charFilter);
        [MethodId(82)]
        Result LeGetFirstDescriptorImpl(Out<GattId> descrOut, uint32_t connId, GattId serviceId, bool isPrimary, GattId charIn, GattAttributeUuid descrFilter);
        [MethodId(83)]
        Result LeGetNextDescriptorImpl(Out<GattId> descrOut, uint32_t connId, GattId serviceId, bool isPrimary, GattId charIn, GattId descrIn, GattAttributeUuid descrFilter);
        [MethodId(84)]
        Result RegisterLeCoreDataPathImpl(GattAttributeUuid uuid);
        [MethodId(85)]
        Result UnregisterLeCoreDataPathImpl(GattAttributeUuid uuid);
        [MethodId(86)]
        Result RegisterLeHidDataPathImpl(GattAttributeUuid uuid);
        [MethodId(87)]
        Result UnregisterLeHidDataPathImpl(GattAttributeUuid uuid);
        [MethodId(88)]
        Result RegisterLeDataPathImpl(GattAttributeUuid uuid);
        [MethodId(89)]
        Result UnregisterLeDataPathImpl(GattAttributeUuid uuid);
        [MethodId(90)]
        Result LeClientReadCharacteristicImpl(uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, uint8_t authType);
        [MethodId(91)]
        Result LeClientReadDescriptorImpl(uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, GattId descrId, uint8_t authType);
        [MethodId(92)]
        Result LeClientWriteCharacteristicImpl(uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, InArray<uint8_t> pData, uint8_t authType, bool withResponse);
        [MethodId(93)]
        Result LeClientWriteDescriptorImpl(uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, GattId descrId, InArray<uint8_t> pData, uint8_t authType);
        [MethodId(94)]
        Result LeClientRegisterNotificationImpl(uint32_t connId, GattId serviceId, bool isPrimary, GattId charId);
        [MethodId(95)]
        Result LeClientDeregisterNotificationImpl(uint32_t connId, GattId serviceId, bool isPrimary, GattId charId);
        [MethodId(96)]
        Result GetLeHidEventInfoImpl(Out<uint32_t> pEventType, OutArray<uint8_t> pOutArray);
        [MethodId(97)]
        Result RegisterBleHidEventImpl(Out<NativeHandle> handle);
        [MethodId(98)]
        Result SetLeScanParameterImpl(uint16_t scanInterval, uint16_t scanWindow);

        [MethodId(256)]
        bool GetIsManufacturingModeImpl();
    }

    [CppRefPath(@"<nn/bluetooth/bluetooth_IBluetoothDriver.sfdl.h>")]
    public interface IBluetoothUser : IServiceObject
    {
        [MethodId(0)]
        Result LeClientReadCharacteristicImpl(nn.applet.CheckedAppletResourceUserId aruid,
                                              uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, uint8_t authType);
        [MethodId(1)]
        Result LeClientReadDescriptorImpl(nn.applet.CheckedAppletResourceUserId aruid,
                                          uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, GattId descrId, uint8_t authType);
        [MethodId(2)]
        Result LeClientWriteCharacteristicImpl(nn.applet.CheckedAppletResourceUserId aruid,
                                               uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, InArray<uint8_t> pData, uint8_t authType, bool withResponse);
        [MethodId(3)]
        Result LeClientWriteDescriptorImpl(nn.applet.CheckedAppletResourceUserId aruid,
                                           uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, GattId descrId, InArray<uint8_t> pData, uint8_t authType);
        [MethodId(4)]
        Result LeClientRegisterNotificationImpl(nn.applet.CheckedAppletResourceUserId aruid,
                                                uint32_t connId, GattId serviceId, bool isPrimary, GattId charId);
        [MethodId(5)]
        Result LeClientDeregisterNotificationImpl(nn.applet.CheckedAppletResourceUserId aruid,
                                                  uint32_t connId, GattId serviceId, bool isPrimary, GattId charId);
        [MethodId(6)]
        Result SetLeResponseImpl(nn.applet.CheckedAppletResourceUserId aruid,
                                 uint8_t serverIf, GattAttributeUuid serviceUuid, GattAttributeUuid attrUuid, InArray<uint8_t> pData);
        [MethodId(7)]
        Result LeSendIndicationImpl(nn.applet.CheckedAppletResourceUserId aruid,
                                    uint8_t serverIf, GattAttributeUuid serviceUuid, GattAttributeUuid charUuid, InArray<uint8_t> pData, bool confirm);
        [MethodId(8)]
        Result GetLeEventInfoImpl(Out<uint32_t> pEventType, OutArray<uint8_t> pOutArray,
                                  nn.applet.CheckedAppletResourceUserId aruid);
        [MethodId(9)]
        Result RegisterBleEventImpl(Out<NativeHandle> handle,
                                    nn.applet.CheckedAppletResourceUserId aruid);
    }
}
