﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkLog.h>
#include <nn/bluetooth/bluetooth_GattAttribute.h>

namespace nn { namespace bluetooth {

    GattAttribute::GattAttribute() NN_NOEXCEPT
    {
        m_Type = GattAttributeType_Unknown;

        m_Handle = GattAttributeInvalidHandle;

        m_ConnectionHandle = BleInvalidConnectionHandle;

        m_Uuid.length = GattAttributeUuidLength_16;
        m_Uuid.uu.uuid16 = 0x0000;
    }

    GattAttribute::GattAttribute(const GattAttributeUuid& uuid, uint16_t handle, uint32_t connectionHandle) NN_NOEXCEPT
    {
        m_Type = GattAttributeType_Unknown;

        m_Handle = handle;

        m_ConnectionHandle = connectionHandle;

        m_Uuid = uuid;
    }

    GattAttribute::~GattAttribute() NN_NOEXCEPT
    {
        // 何もしない
    }

    GattAttributeType GattAttribute::GetType() const NN_NOEXCEPT
    {
        return m_Type;
    }

    GattAttributeUuid GattAttribute::GetUuid() const NN_NOEXCEPT
    {
        return m_Uuid;
    }

    uint16_t GattAttribute::GetHandle() const NN_NOEXCEPT
    {
        return m_Handle;
    }

    uint32_t GattAttribute::GetConnectionHandle() const NN_NOEXCEPT
    {
        return m_ConnectionHandle;
    }
}}  // namespace nn::bluetooth
