﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include <nn/bluetooth/bluetooth_Driver.h>

#include "bluetooth_DriverImpl.h"

namespace nn { namespace bluetooth {

namespace
{
    nn::sf::UnmanagedServiceObject<IBluetoothDriver, BluetoothDriverImpl> g_BluetoothDriver;
}

nn::sf::SharedPointer<IBluetoothDriver> CreateBluetoothDriverByDfc() NN_NOEXCEPT
{
    return g_BluetoothDriver.GetShared();
}

}}  // namespace nn::bluetooth

