﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/os/os_TransferMemory.h>
#include <nn/os/os_SharedMemory.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include <nn/bluetooth/bluetooth_IBluetoothDriver.sfdl.h>

//tentatively include it. Eventually Impl codes have to be put the Sources/Processes/bluetooth.
#include "../../Processes/bluetooth/bluetooth.h"

namespace nn { namespace bluetooth {

//-----------------------------------------------------------------------------
//  IBluetoothDriver の実装用クラス
//
//  IBluetoothDriver を直接継承はせず、各関数のシグネチャだけ合わせる。
//-----------------------------------------------------------------------------
class BluetoothDriverImpl
{
private:
public:
    //APIs
    nn::Result WaitServerReady() NN_NOEXCEPT;

    nn::Result InitializeBluetoothImpl(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
    nn::Result EnableBluetoothImpl() NN_NOEXCEPT;
    nn::Result DisableBluetoothImpl() NN_NOEXCEPT;
    nn::Result CleanupBluetoothImpl() NN_NOEXCEPT;
    nn::Result GetAdapterPropertiesImpl(nn::sf::Out<nn::bluetooth::AdapterProperty> pAdapterProperty) NN_NOEXCEPT;
    nn::Result GetAdapterPropertyImpl(BluetoothPropertyType propertyType, const nn::sf::OutArray<std::uint8_t>& outArray) NN_NOEXCEPT;
    nn::Result SetAdapterPropertyImpl(BluetoothPropertyType propertyType, const nn::sf::InArray<std::uint8_t>& inArray) NN_NOEXCEPT;
    nn::Result StartDiscoveryImpl() NN_NOEXCEPT;
    nn::Result CancelDiscoveryImpl() NN_NOEXCEPT;
    nn::Result CreateBondImpl(BluetoothAddress bluetoothAddress, BluetoothTransport transport) NN_NOEXCEPT;
    nn::Result RemoveBondImpl(BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
    nn::Result CancelBondImpl(BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
    nn::Result PinReplyImpl(BluetoothAddress bluetoothAddress, uint8_t accept, uint8_t pinLength, BluetoothPinCode pinCode) NN_NOEXCEPT;
    nn::Result SspReplyImpl(BluetoothAddress bluetoothAddress, uint8_t variant, uint8_t accept, uint32_t passkey) NN_NOEXCEPT;

    nn::Result GetEventInfoImpl(nn::sf::Out<uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& outArray) NN_NOEXCEPT;

    nn::Result InitializeHidImpl(nn::sf::Out<nn::sf::NativeHandle> pOutHandle, uint16_t interfaceVersion) NN_NOEXCEPT;
    nn::Result HidConnectImpl(BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
    nn::Result HidDisconnectImpl(BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
    nn::Result HidSendDataByStructureImpl(BluetoothAddress bluetoothAddress, HidData data) NN_NOEXCEPT;
    nn::Result HidSendDataImpl(BluetoothAddress bluetoothAddress, const nn::sf::InArray<std::uint8_t>& inArray) NN_NOEXCEPT;
    nn::Result HidSetReportImpl(BluetoothAddress bluetoothAddress, BluetoothHhReportType reportType, HidData data) NN_NOEXCEPT;
    nn::Result HidGetReportImpl(BluetoothAddress bluetoothAddress, BluetoothHhReportType reportType, uint8_t reportId) NN_NOEXCEPT;
    nn::Result HidWakeControllerImpl(BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
    nn::Result HidAddPairedDeviceImpl(nn::settings::system::BluetoothDevicesSettings device) NN_NOEXCEPT;
    nn::Result HidGetPairedDeviceImpl(BluetoothAddress bluetoothAddress, nn::sf::Out<nn::settings::system::BluetoothDevicesSettings> deviceOut) NN_NOEXCEPT;

    nn::Result CleanupHidImpl() NN_NOEXCEPT;

    nn::Result HidGetEventInfoImpl(nn::sf::Out<uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& outArray) NN_NOEXCEPT;
    nn::Result RegisterHidReportEventImpl(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
    nn::Result HidGetReportEventInfoImpl(nn::sf::Out<uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& outArray) NN_NOEXCEPT;

    nn::Result ExtSetTsiImpl(BluetoothAddress bluetoothAddress, uint8_t tsiMode) NN_NOEXCEPT;
    nn::Result ExtSetBurstModeImpl(BluetoothAddress bluetoothAddress, bool isBurst) NN_NOEXCEPT;
    nn::Result ExtSetZeroRetranImpl(BluetoothAddress bluetoothAddress, const nn::sf::InArray<std::uint8_t>& pReportIds) NN_NOEXCEPT;
    nn::Result ExtSetMcModeImpl(bool isMcModeEnabled) NN_NOEXCEPT;
    nn::Result ExtStartLlrModeImpl() NN_NOEXCEPT;
    nn::Result ExtExitLlrModeImpl() NN_NOEXCEPT;
    nn::Result ExtSetRadioImpl(bool enable) NN_NOEXCEPT;
    nn::Result ExtSetVisibilityImpl(bool discoverable, bool connectable) NN_NOEXCEPT;
    nn::Result ExtSetTbfcScanImpl(bool enable) NN_NOEXCEPT;
    nn::Result ExtGetPendingConnectionsImpl() NN_NOEXCEPT;

    nn::Result GetLatestPlrImpl(nn::sf::Out<nn::bluetooth::PlrStatistics> pOut) NN_NOEXCEPT;

    nn::Result GetChannelMapImpl(nn::sf::Out<ChannelMap> pOutChannelMap) NN_NOEXCEPT;

    nn::Result EnableBluetoothBoostSettingImpl(bool enable) NN_NOEXCEPT;
    nn::Result IsBluetoothBoostEnabledImpl(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
    nn::Result EnableBluetoothAfhSettingImpl(bool enable) NN_NOEXCEPT;
    nn::Result IsBluetoothAfhEnabledImpl(nn::sf::Out<bool> pOut) NN_NOEXCEPT;

    nn::Result InitializeBleImpl(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
    nn::Result EnableBleImpl() NN_NOEXCEPT;
    nn::Result DisableBleImpl() NN_NOEXCEPT;
    nn::Result CleanupBleImpl() NN_NOEXCEPT;
    nn::Result SetLeVisibilityImpl(bool discoverable, bool connectable) NN_NOEXCEPT;
    nn::Result SetLeConnectionParameterImpl(LeConnectionParams connectionParams) NN_NOEXCEPT;
    nn::Result SetLeDefaultConnectionParameterImpl(LeConnectionParams connectionParams) NN_NOEXCEPT;
    nn::Result SetLeAdvertiseDataImpl(LeAdvertiseData advertiseData) NN_NOEXCEPT;
    nn::Result SetLeAdvertiseParameterImpl(BluetoothAddress bluetoothAddress, uint16_t minAdvInt, uint16_t maxAdvInt) NN_NOEXCEPT;
    nn::Result StartLeScanImpl() NN_NOEXCEPT;
    nn::Result StopLeScanImpl() NN_NOEXCEPT;
    nn::Result SetLeScanParameterImpl(uint16_t scanInterval, uint16_t scanWindow) NN_NOEXCEPT;
    nn::Result AddLeScanFilterConditionImpl(BleAdvertiseFilter filter) NN_NOEXCEPT;
    nn::Result DeleteLeScanFilterConditionImpl(BleAdvertiseFilter filter) NN_NOEXCEPT;
    nn::Result DeleteLeScanFilterImpl(uint8_t filterIndex) NN_NOEXCEPT;
    nn::Result ClearLeScanFiltersImpl() NN_NOEXCEPT;
    nn::Result EnableLeScanFilterImpl(bool enable) NN_NOEXCEPT;
    nn::Result RegisterLeClientImpl(GattAttributeUuid uuid) NN_NOEXCEPT;
    nn::Result UnregisterLeClientImpl(uint8_t clientIf) NN_NOEXCEPT;
    nn::Result UnregisterLeClientAllImpl() NN_NOEXCEPT;
    nn::Result LeClientConnectImpl(const nn::applet::AppletResourceUserId& aruid, uint8_t clientIf, BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT;
    nn::Result LeClientCancelConnectionImpl(uint8_t clientIf, BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT;
    nn::Result LeClientDisconnectImpl(uint32_t connId) NN_NOEXCEPT;
    nn::Result LeClientGetAttributesImpl(uint32_t connId, BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
    nn::Result LeClientDiscoverServiceImpl(uint32_t connId, GattAttributeUuid filterUuid) NN_NOEXCEPT;
    nn::Result LeClientConfigureMtu(uint32_t connId, uint16_t mtu);
    nn::Result RegisterLeServerImpl(GattAttributeUuid uuid) NN_NOEXCEPT;
    nn::Result UnregisterLeServerImpl(uint8_t serverIf) NN_NOEXCEPT;
    nn::Result LeServerConnectImpl(uint8_t clientIf, BluetoothAddress bluetoothAddress, bool isDirect) NN_NOEXCEPT;
    nn::Result LeServerDisconnectImpl(uint8_t clientIf, BluetoothAddress bluetoothAddress) NN_NOEXCEPT;
    nn::Result CreateLeServiceImpl(uint8_t serverIf, GattAttributeUuid uuid, uint8_t handleNum, bool isPrimaryService) NN_NOEXCEPT;
    nn::Result StartLeServiceImpl(uint8_t serverIf, GattAttributeUuid uuid) NN_NOEXCEPT;
    nn::Result AddLeCharacteristicImpl(uint8_t serverIf, GattAttributeUuid serviceUuid, GattAttributeUuid charUuid, uint16_t permissions, uint8_t properties) NN_NOEXCEPT;
    nn::Result AddLeDescriptorImpl(uint8_t serverIf, GattAttributeUuid serviceUuid, GattAttributeUuid descUuid, uint16_t permissions) NN_NOEXCEPT;
    nn::Result LeGetFirstCharacteristicImpl(nn::sf::Out<nn::bluetooth::GattId> charOut, nn::sf::Out<std::uint8_t> property, uint32_t connId, GattId serviceId, bool isPrimary, GattAttributeUuid charFilter) NN_NOEXCEPT;
    nn::Result LeGetNextCharacteristicImpl(nn::sf::Out<nn::bluetooth::GattId> charOut, nn::sf::Out<std::uint8_t> property, uint32_t connId, GattId serviceId, bool isPrimary, GattId charIn, GattAttributeUuid charFilter) NN_NOEXCEPT;
    nn::Result LeGetFirstDescriptorImpl(nn::sf::Out<nn::bluetooth::GattId> descrOut, uint32_t connId, GattId serviceId, bool isPrimary, GattId charIn, GattAttributeUuid descrFilter) NN_NOEXCEPT;
    nn::Result LeGetNextDescriptorImpl(nn::sf::Out<nn::bluetooth::GattId> descrOut, uint32_t connId, GattId serviceId, bool isPrimary, GattId charIn, GattId descrIn, GattAttributeUuid descrFilter) NN_NOEXCEPT;
    nn::Result RegisterLeCoreDataPathImpl(GattAttributeUuid uuid) NN_NOEXCEPT;
    nn::Result UnregisterLeCoreDataPathImpl(GattAttributeUuid uuid) NN_NOEXCEPT;
    nn::Result RegisterLeHidDataPathImpl(GattAttributeUuid uuid) NN_NOEXCEPT;
    nn::Result UnregisterLeHidDataPathImpl(GattAttributeUuid uuid) NN_NOEXCEPT;
    nn::Result RegisterLeDataPathImpl(GattAttributeUuid uuid) NN_NOEXCEPT;
    nn::Result UnregisterLeDataPathImpl(GattAttributeUuid uuid) NN_NOEXCEPT;

    nn::Result GetLeCoreEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& outArray) NN_NOEXCEPT;

    nn::Result RegisterBleHidEventImpl(nn::sf::Out<nn::sf::NativeHandle> pOutHandle) NN_NOEXCEPT;
    nn::Result GetLeHidEventInfoImpl(nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& outArray) NN_NOEXCEPT;

    /* Same features in Bluetooth User Impl for BTM and HID */
    nn::Result LeClientReadCharacteristicImpl(uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, uint8_t authType) NN_NOEXCEPT;
    nn::Result LeClientReadDescriptorImpl(uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, GattId descrId, uint8_t authType) NN_NOEXCEPT;
    nn::Result LeClientWriteCharacteristicImpl(uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, const nn::sf::InArray<std::uint8_t>& pData, uint8_t authType, bool withResponse) NN_NOEXCEPT;
    nn::Result LeClientWriteDescriptorImpl(uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, GattId descrId, const nn::sf::InArray<std::uint8_t>& pData, uint8_t authType) NN_NOEXCEPT;
    nn::Result LeClientRegisterNotificationImpl(uint32_t connId, GattId serviceId, bool isPrimary, GattId charId) NN_NOEXCEPT;
    nn::Result LeClientDeregisterNotificationImpl(uint32_t connId, GattId serviceId, bool isPrimary, GattId charId) NN_NOEXCEPT;

    bool GetIsManufacturingModeImpl() NN_NOEXCEPT;
};

class BluetoothUserImpl
{
private:
public:
    nn::Result LeClientReadCharacteristicImpl(
        const nn::applet::AppletResourceUserId& aruid,
        uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, uint8_t authType) NN_NOEXCEPT;

    nn::Result LeClientReadDescriptorImpl(
        const nn::applet::AppletResourceUserId& aruid,
        uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, GattId descrId, uint8_t authType) NN_NOEXCEPT;

    nn::Result LeClientWriteCharacteristicImpl(
        const nn::applet::AppletResourceUserId& aruid,
        uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, const nn::sf::InArray<std::uint8_t>& pData, uint8_t authType, bool withResponse) NN_NOEXCEPT;

    nn::Result LeClientWriteDescriptorImpl(
        const nn::applet::AppletResourceUserId& aruid,
        uint32_t connId, GattId serviceId, bool isPrimary, GattId charId, GattId descrId, const nn::sf::InArray<std::uint8_t>& pData, uint8_t authType) NN_NOEXCEPT;

    nn::Result LeClientRegisterNotificationImpl(
        const nn::applet::AppletResourceUserId& aruid,
        uint32_t connId, GattId serviceId, bool isPrimary, GattId charId) NN_NOEXCEPT;

    nn::Result LeClientDeregisterNotificationImpl(
        const nn::applet::AppletResourceUserId& aruid,
        uint32_t connId, GattId serviceId, bool isPrimary, GattId charId) NN_NOEXCEPT;

    nn::Result SetLeResponseImpl(
        const nn::applet::AppletResourceUserId& aruid,
        uint8_t serverIf, GattAttributeUuid serviceUuid, GattAttributeUuid attrUuid, const nn::sf::InArray<std::uint8_t>& pData) NN_NOEXCEPT;

    nn::Result LeSendIndicationImpl(
        const nn::applet::AppletResourceUserId& aruid,
        uint8_t serverIf, GattAttributeUuid serviceUuid, GattAttributeUuid charUuid, const nn::sf::InArray<std::uint8_t>& pData, bool confirm) NN_NOEXCEPT;

    nn::Result GetLeEventInfoImpl(
        nn::sf::Out<std::uint32_t> pEventType, const nn::sf::OutArray<std::uint8_t>& outArray,
        const nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT;

    nn::Result RegisterBleEventImpl(
        nn::sf::Out<nn::sf::NativeHandle> pOutHandle,
        const nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT;
};

//Callbacks. Can't merge callbacks to the class because the HAL uses generic functional pointer.
/*
 void AdapterStateChangedCallback(BluetoothState state) NN_NOEXCEPT;
 void AdapterPropertiesCallback(BluetoothIfStatus status, int NumProperties, BluetoothProperty *properties) NN_NOEXCEPT;
 void RemoteDevicePropertiesCallback(BluetoothIfStatus status, Btbdaddr *pBdAddr, int NumProperties, BluetoothProperty *properties) NN_NOEXCEPT;
 void DeviceFoundCallback(int NumProperties, BluetoothProperty *properties) NN_NOEXCEPT;
 void DiscoveryStateChangedCallback(BluetoothDiscoveryState state) NN_NOEXCEPT;
 void PinRequestCallback(Btbdaddr *pBdAddr, Btbdname *pBdName, uint32_t cod) NN_NOEXCEPT;
 void SspRequestCallback( Btbdaddr *pBdAddr, Btbdname *pBdName, uint32_t cod, BluetoothSspVariant PairingVariant, uint32_t pass_key ) NN_NOEXCEPT;
 void BondStateChangedCallback(BluetoothIfStatus status, Btbdaddr *pBdAddr, BluetoothBondState state) NN_NOEXCEPT;
 void AclStateChangedCallback(BluetoothIfStatus status, Btbdaddr *pBdAddr, BluetoothAclState state) NN_NOEXCEPT;
 void CallbackThreadEventCallback(BluetoothCallbackThreadEvent evt) NN_NOEXCEPT;
 void DutModeReceivedCallback(uint16_t opcode, uint8_t *buffer, uint8_t len) NN_NOEXCEPT;
 void LEtestModeCallback(BluetoothIfStatus status, uint16_t NumPackets) NN_NOEXCEPT;
 void EnergyInfoCallback(BluetoothActivityEnergyInfo *pEnergyInfo) NN_NOEXCEPT;
*/

NN_OS_EXTERN_C void Bluetooth_HAL_test_API(const char *api);

//-----------------------------------------------------------------------------

}}  // namespace nn::bluetooth

