﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/bpc/bpc_Rtc.h>
#include <nn/bpc/bpc_WakeupConfig.h>
#include <algorithm>

#include "bgtc_RealTimeClock.h"
#include "bgtc_Common.h"

namespace nn{ namespace bgtc{

Time GetNow()
{
    int64_t timeRtc = 0;
#ifdef NN_BUILD_CONFIG_OS_HORIZON
    Result result = bpc::GetRtcTime(&timeRtc);
    if (result.IsFailure())
    {
        NN_BGTC_ERROR("bpc::GetRtcTime failed.(0x%08x)\n", result.GetInnerValueForDebug());
    }
#endif
    return static_cast<Time>(timeRtc);
}

void SetupWakeTrigger(Interval interval)
{
#ifdef NN_BUILD_CONFIG_OS_HORIZON
    int handle;
    interval = std::max<Interval>(interval, bpc::MinWakeupIntervalInSeconds);
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        bpc::CreateWakeupTimer(&handle, TimeSpan::FromSeconds(interval), bpc::WakeupTimerType_BackgroundTask)
    );
#else
    NN_UNUSED(interval);
#endif
}


}}
