﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/bgtc/detail/bgtc_HipcPorts.h>
#include <nn/bgtc/detail/bgtc_ITaskService.sfdl.h>
#include <nn/bgtc/detail/bgtc_IStateControlService.sfdl.h>

#include "bgtc_IpcServerManager.h"
#include "bgtc_TaskServiceImpl.h"
#include "bgtc_StateControlServiceImpl.h"

namespace nn { namespace bgtc {
namespace {

//-----------------------------------------------------------------------------
// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct  HipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 8, HipcTag> Allocator;

}   // namespace

IpcServerManager::IpcServerManager()
{
}

IpcServerManager::~IpcServerManager()
{
}

void IpcServerManager::Initialize()
{
    Allocator::Initialize(nn::lmem::CreationOption_NoOption);

    Result result;

    for (int i = 0; i < PortIndex_Count; ++i)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(
            InitializePort(i, SessionCountPerPort, PortNames[i])
        );
    }

    Start();
}

void IpcServerManager::Finalize()
{
    RequestStop();
}

nn::Result IpcServerManager::OnNeedsToAccept(int portIndex, PortObjectImpl* pPort) NN_NOEXCEPT
{
    switch (portIndex)
    {
    case PortIndex_TaskService:
    {
        sf::SharedPointer<ITaskService> pInterface =
            sf::ObjectFactory<Allocator::Policy>::CreateSharedEmplaced<ITaskService,         TaskServiceImpl>();
        if (pInterface == nullptr)
        {
            return ResultOutOfMemory();
        }
        return AcceptImpl(pPort, pInterface);
    }
    case PortIndex_StateControlService:
    {
        sf::SharedPointer<IStateControlService> pInterface =
            sf::ObjectFactory<Allocator::Policy>::CreateSharedEmplaced<IStateControlService, StateControlServiceImpl>();
        if (pInterface == nullptr)
        {
            return ResultOutOfMemory();
        }
        return AcceptImpl(pPort, pInterface);
    }
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

}}
