﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/bpc/bpc_Rtc.h>
#include <nn/bpc/bpc_WakeupConfig.h>
#include <nn/psm/psm.h>
#include <mutex>
#include <cstdlib>

#include "bgtc_Common.h"
#include "bgtc_Instance.h"
#include "bgtc_IpcServerManager.h"
#include "bgtc_ClientBroker.h"
#include "bgtc_CompositeEventHandlerThread.h"

namespace nn{ namespace bgtc{

namespace
{
    Instance s_Instance;

    IpcServerManager s_IpcServerManager;
    NN_OS_ALIGNAS_THREAD_STACK CompositeEventHandlerThread s_CompositeEventHandlerThread;
    ClientBroker s_ClientBroker;
}

Instance& g_Instance = s_Instance;

Instance::Instance()
    : m_ClientBroker(s_ClientBroker)
    , m_IpcServerManager(s_IpcServerManager)
    , m_CompositeEventHandlerThread(s_CompositeEventHandlerThread)
{
}

void Instance::Initialize()
{
#ifdef NN_BUILD_CONFIG_OS_HORIZON
    bpc::InitializeRtc();
    bpc::InitializeWakeupConfig();
    psm::Initialize();
#endif
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        m_CompositeEventHandlerThread.Initialize()
    );

#if NN_BGTC_ENABLE_HIPC
    m_IpcServerManager.Initialize();
#endif
}

void Instance::Finalize()
{
#if NN_BGTC_ENABLE_HIPC
    m_IpcServerManager.Finalize();
    m_IpcServerManager.~IpcServerManager(); // static dtor に任せるとメモリの開放が遅れる
#endif

    m_CompositeEventHandlerThread.Finalize();
#ifdef NN_BUILD_CONFIG_OS_HORIZON
    psm::Finalize();
    bpc::FinalizeWakeupConfig();
    bpc::FinalizeRtc();
#endif
}

}}

// --------------

#include <nn/bgtc/detail/bgtc_Serve.h>

namespace nn{ namespace bgtc{

void Serve()
{
    g_Instance.Initialize();
    g_Instance.GetIpcServerManager().LoopAuto();
    g_Instance.Finalize();
}

}}
