﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/bgtc/detail/bgtc_ITaskService.sfdl.h>
#include <nn/bgtc/detail/bgtc_IStateControlService.sfdl.h>
#include <nn/bgtc/detail/bgtc_HipcPorts.h>

namespace nn { namespace bgtc {

namespace {
    //-----------------------------------------------------------------------------
    // 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
    struct  HipcTag;
    typedef nn::sf::ExpHeapStaticAllocator<1024 * 4, HipcTag> Allocator;

    //-----------------------------------------------------------------------------
    // Allocator を静的コンストラクタで初期化するためのヘルパー
    class AllocatorInitializer
    {
    public:

        AllocatorInitializer() NN_NOEXCEPT
        {
            Allocator::Initialize(nn::lmem::CreationOption_NoOption);
        }

    } g_AllocatorInitializer;

    template<typename T, Result(T::* MethodName)(nn::sf::Out<sf::NativeHandle>outHandle)>
    Result AttachEventByService(T & service, os::SystemEvent & event, os::EventClearMode clearMode)
    {
        nn::sf::NativeHandle outHandle;
        Result result = (service.*MethodName)(&outHandle);
        if (result.IsFailure())
        {
            return result;
        }

        event.AttachReadableHandle(
            outHandle.GetOsHandle(), outHandle.IsManaged(),
            clearMode
        );
        outHandle.Detach();
        return ResultSuccess();
    }
}

}}
