﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/bcat/detail/service/core/bcat_PublicKey.h>
#include <nn/bcat/detail/service/core/bcat_ProductionMode.h>

namespace nn { namespace bcat { namespace detail { namespace service { namespace core {

namespace
{
    const Bit8 ModulusForProd[] =
    {
        0x00, 0xBB, 0x4E, 0x9D, 0x60, 0x01, 0x4B, 0x3D, 0x3B, 0x78, 0xE8, 0x0B, 0x26, 0x7D, 0xD7,
        0xBB, 0xC2, 0xD8, 0x66, 0x7E, 0x48, 0x7D, 0xC4, 0x23, 0x69, 0xEA, 0x60, 0x6A, 0xC6, 0xE1,
        0xD1, 0x22, 0xDE, 0xB1, 0x46, 0xF3, 0xE5, 0x4D, 0x49, 0x87, 0x3D, 0x5F, 0xF4, 0xF7, 0x92,
        0xA5, 0x87, 0x50, 0x07, 0x9D, 0xF2, 0x8A, 0xAD, 0xE7, 0x0B, 0x5B, 0x33, 0x22, 0x49, 0x53,
        0x69, 0xF1, 0x8B, 0xDE, 0x51, 0xED, 0xE1, 0xC4, 0xB2, 0xF1, 0xA2, 0x98, 0x29, 0x10, 0xF8,
        0x37, 0x22, 0x0F, 0x44, 0x18, 0x02, 0xB8, 0x49, 0xA1, 0x92, 0x34, 0x1E, 0xD8, 0xFF, 0xC6,
        0x8A, 0x4D, 0x4B, 0xD6, 0x55, 0x5E, 0x14, 0xC2, 0x7C, 0x80, 0x2B, 0xF8, 0xC0, 0x07, 0xCC,
        0x7D, 0x69, 0x96, 0xED, 0x5C, 0xA9, 0x2D, 0xEC, 0x5D, 0x6F, 0xCF, 0x45, 0xFC, 0x04, 0xD6,
        0x04, 0xCE, 0xCC, 0x9A, 0xF1, 0x9B, 0x28, 0xF3, 0x6E, 0xAF, 0x95, 0xDF, 0x90, 0x99, 0x47,
        0x59, 0xD3, 0x08, 0xE7, 0xDD, 0x45, 0xF9, 0xC7, 0xA6, 0x40, 0x9C, 0x39, 0xDC, 0x9D, 0x9C,
        0x32, 0x5A, 0xD4, 0xCB, 0x73, 0xCF, 0x76, 0x3F, 0x21, 0x17, 0x7E, 0xE2, 0x5B, 0x56, 0x05,
        0x10, 0x10, 0xA0, 0xA3, 0x10, 0x6F, 0x2B, 0x66, 0xA7, 0xC4, 0x34, 0xC9, 0xCE, 0x22, 0x45,
        0x44, 0x80, 0x33, 0x4F, 0x52, 0x80, 0xE7, 0xE6, 0x64, 0x1D, 0x18, 0xF4, 0x3E, 0xB0, 0xF3,
        0xCE, 0x65, 0x5B, 0x9C, 0xDD, 0xF6, 0x87, 0xEC, 0xDD, 0xB3, 0xF0, 0x14, 0xC2, 0x9B, 0xAB,
        0xC3, 0xE8, 0x73, 0x4D, 0xD4, 0x49, 0x5A, 0xF1, 0xBB, 0x07, 0xA9, 0xC4, 0xF3, 0x61, 0x25,
        0xDD, 0x9F, 0xA6, 0x64, 0x46, 0xC8, 0xC7, 0xF1, 0x10, 0xB3, 0x0B, 0x41, 0x3E, 0x3D, 0x76,
        0x66, 0xD1, 0x01, 0xC9, 0x50, 0x34, 0x6A, 0x14, 0x11, 0x68, 0x46, 0xD7, 0x72, 0x47, 0x3E,
        0xBF, 0x89
    };

    const Bit8 ExponentForProd[] =
    {
        0x01, 0x00, 0x01
    };

    const Bit8 ModulusForDev[] =
    {
        0x00, 0xB3, 0x02, 0x96, 0x6F, 0x8A, 0x1F, 0x9E, 0xF5, 0x37, 0xC8, 0xEA, 0x25, 0xCD, 0x50,
        0x86, 0xD9, 0x2A, 0x14, 0x8A, 0x27, 0x65, 0xAA, 0xCE, 0xAF, 0x32, 0x82, 0x2D, 0x8C, 0x1C,
        0x61, 0xD2, 0x16, 0x76, 0x4D, 0x82, 0xEB, 0xB2, 0x6A, 0x8B, 0x7A, 0x29, 0x69, 0xAE, 0x3C,
        0x55, 0x61, 0x9B, 0x2B, 0x62, 0x08, 0x30, 0x77, 0x4E, 0x89, 0x03, 0x68, 0xEF, 0xA8, 0xEE,
        0xDE, 0x5B, 0xA9, 0x2B, 0x60, 0x08, 0x1B, 0x80, 0x6C, 0x57, 0x64, 0xD1, 0x45, 0x7A, 0xF2,
        0x18, 0xA0, 0x18, 0x4A, 0x68, 0xB5, 0x74, 0x6C, 0xD9, 0x21, 0x1B, 0xE5, 0x8C, 0x06, 0x1F,
        0x84, 0x06, 0x0F, 0x09, 0x54, 0x2B, 0x28, 0x2B, 0xD9, 0xB6, 0x22, 0x96, 0x83, 0x50, 0x38,
        0x29, 0xC2, 0xE4, 0x0A, 0x45, 0xC3, 0x9B, 0x63, 0xD6, 0xD2, 0x47, 0xC7, 0x46, 0x1E, 0x61,
        0xF7, 0x6C, 0xE2, 0x16, 0xBB, 0x9A, 0x83, 0x91, 0xE5, 0x91, 0xA2, 0x2D, 0x6A, 0x99, 0x85,
        0x09, 0x00, 0xDC, 0x89, 0x11, 0x3F, 0x9C, 0xB0, 0x3E, 0xD3, 0x55, 0x28, 0xF2, 0x6B, 0x7D,
        0x04, 0xB7, 0xA1, 0xEF, 0x02, 0xB7, 0xC0, 0x1B, 0x33, 0xF5, 0x4E, 0xB2, 0x67, 0xF0, 0x0D,
        0x76, 0xD6, 0x3D, 0x64, 0x02, 0x5D, 0x88, 0x7F, 0x57, 0xD1, 0x3B, 0xC8, 0x37, 0x53, 0x8B,
        0x66, 0x15, 0xDA, 0xAF, 0x55, 0x6A, 0x70, 0xE0, 0x9F, 0xE2, 0x7C, 0xC1, 0xD5, 0xEB, 0xDB,
        0x1E, 0xB0, 0x00, 0x6C, 0x2B, 0x1A, 0xD8, 0x96, 0xC2, 0xBE, 0x86, 0xD9, 0x02, 0x9F, 0xD1,
        0xA7, 0x12, 0x6E, 0xFB, 0x3E, 0x6C, 0x7B, 0x49, 0x11, 0x4F, 0x8E, 0x94, 0x5D, 0xC3, 0xAC,
        0xD8, 0xA4, 0x07, 0x2C, 0xC4, 0x5E, 0x30, 0xAA, 0x35, 0xA9, 0x15, 0x34, 0x1D, 0xAB, 0xA7,
        0x84, 0xF4, 0x4C, 0xA0, 0xC1, 0xFE, 0x92, 0xCE, 0xAF, 0x0C, 0x92, 0x91, 0xED, 0xEC, 0xEB,
        0xDD, 0x0B
    };

    const Bit8 ExponentForDev[] =
    {
        0x01, 0x00, 0x01
    };
}

const Bit8* PublicKey::GetModulus() NN_NOEXCEPT
{
    if (ProductionMode::IsProduction())
    {
        return ModulusForProd;
    }
    else
    {
        return ModulusForDev;
    }
};

size_t PublicKey::GetModulusSize() NN_NOEXCEPT
{
    if (ProductionMode::IsProduction())
    {
        return sizeof (ModulusForProd);
    }
    else
    {
        return sizeof (ModulusForDev);
    }
};

const Bit8* PublicKey::GetPublicExponent() NN_NOEXCEPT
{
    if (ProductionMode::IsProduction())
    {
        return ExponentForProd;
    }
    else
    {
        return ExponentForDev;
    }
};

size_t PublicKey::GetPublicExponentSize() NN_NOEXCEPT
{
    if (ProductionMode::IsProduction())
    {
        return sizeof (ExponentForProd);
    }
    else
    {
        return sizeof (ExponentForDev);
    }
};

}}}}}
