﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/bcat/detail/service/core/bcat_ParameterConverter.h>

namespace nn { namespace bcat { namespace detail { namespace service { namespace core {

namespace
{
    // MEMO: プラットフォームが増えたら分岐する。
    const char* TopicIdFormatString = "nx_data_%016llx";
}

void ParameterConverter::Convert(TopicId* outTopicId, nn::ApplicationId appId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outTopicId);

    nn::util::SNPrintf(outTopicId->value, sizeof (outTopicId->value), TopicIdFormatString, appId.value);
}

bool ParameterConverter::Convert(nn::ApplicationId* outAppId, const TopicId& topicId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outAppId);

    unsigned long long value = 0;

    if (std::sscanf(topicId.value, TopicIdFormatString, &value) != 1)
    {
        return false;
    }

    outAppId->value = value;

    return true;
}

bool ParameterConverter::Convert(Digest* outDigest, const char* digest) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outDigest);
    NN_SDK_REQUIRES_NOT_NULL(digest);

    unsigned long long v[2];

    if (std::sscanf(digest, "%016llx%016llx", &v[0], &v[1]) != 2)
    {
        return false;
    }

    outDigest->value[0] = v[0];
    outDigest->value[1] = v[1];

    return true;
}

int32_t ParameterConverter::Convert(nn::Result result) NN_NOEXCEPT
{
    int32_t value = 0;
    std::memcpy(&value, &result, sizeof (value));

    return value;
}

nn::Result ParameterConverter::Convert(int32_t value) NN_NOEXCEPT
{
    nn::Result result;
    std::memcpy(&result, &value, sizeof (result));

    return result;
}

}}}}}
