﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/bcat/detail/service/bcat_ServiceCreator.generic.h>
#include <nn/bcat/detail/service/bcat_BcatService.generic.h>
#include <nn/bcat/detail/service/bcat_DeliveryCacheStorageService.generic.h>
#include <nn/bcat/detail/service/bcat_ServiceMemoryManager.h>
#include <nn/bcat/bcat_Result.h>
#include <nn/bcat/bcat_ResultPrivate.h>
#include <nn/fs.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace bcat { namespace detail { namespace service {

ServiceCreatorForGeneric::ServiceCreatorForGeneric() NN_NOEXCEPT
{
}

ServiceCreatorForGeneric::~ServiceCreatorForGeneric() NN_NOEXCEPT
{
}

nn::Result ServiceCreatorForGeneric::CreateBcatService(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IBcatService>> outService, nn::Bit64 processId) NN_NOEXCEPT
{
    NN_UNUSED(processId);

    auto& allocator = ServiceMemoryManager::GetInstance().GetBcatServiceAllocator();

    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<detail::ipc::IBcatService, BcatServiceForGeneric>(&allocator);

    NN_RESULT_THROW_UNLESS(p, ResultOutOfSessionResource());

    outService.Set(std::move(p));

    NN_RESULT_SUCCESS;
}

nn::Result ServiceCreatorForGeneric::CreateDeliveryCacheStorageService(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheStorageService>> outService, nn::Bit64 processId) NN_NOEXCEPT
{
    NN_UNUSED(processId);

    nn::ApplicationId appId = {0xFFFFFFFFFFFFFFFF};

    NN_RESULT_DO(CreateDeliveryCacheStorageServiceWithApplicationId(outService, appId));

    NN_RESULT_SUCCESS;
}

nn::Result ServiceCreatorForGeneric::CreateDeliveryCacheStorageServiceWithApplicationId(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheStorageService>> outService, nn::ApplicationId appId) NN_NOEXCEPT
{
    NN_UNUSED(appId);

    NN_RESULT_TRY(nn::fs::MountHost("bcat-dc", "./bcat-dc"))
        NN_RESULT_CATCH(nn::fs::ResultPathNotFound)
        {
            NN_RESULT_THROW(ResultStorageNotFound());
        }
        NN_RESULT_CATCH(nn::fs::ResultMountNameAlreadyExists)
        {
            NN_RESULT_THROW(ResultLocked());
        }
    NN_RESULT_END_TRY;

    bool isSuccess = false;

    NN_UTIL_SCOPE_EXIT
    {
        if (!isSuccess)
        {
            nn::fs::Unmount("bcat-dc");
        }
    };

    auto& allocator = ServiceMemoryManager::GetInstance().GetDeliveryCacheStorageServiceAllocator();

    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<detail::ipc::IDeliveryCacheStorageService, DeliveryCacheStorageServiceForGeneric>(&allocator);

    NN_RESULT_THROW_UNLESS(p, ResultOutOfSessionResource());

    outService.Set(std::move(p));

    isSuccess = true;

    NN_RESULT_SUCCESS;
}

}}}}
