﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/bcat/detail/service/bcat_Service.h>
#include <nn/bcat/detail/ipc/bcat_ServiceName.h>
#include <nn/bcat/detail/service/bcat_ServiceCreator.h>
#include <nn/bcat/detail/service/bcat_BcatService.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace bcat { namespace detail { namespace service {

namespace
{
    nn::os::SdkMutexType g_Mutex = NN_OS_SDK_MUTEX_INITIALIZER();

    typedef nn::sf::UnmanagedServiceObject<detail::ipc::IServiceCreator, ServiceCreator> ServiceCreatorObject;

    std::aligned_storage<sizeof (ServiceCreatorObject)>::type g_Storages[detail::ipc::ServiceCount];
    ServiceCreatorObject* g_Objects[detail::ipc::ServiceCount] = {};
}

void InitializeServiceCreator(int index, const char* serviceName, Bit32 capability) NN_NOEXCEPT
{
    std::lock_guard<decltype (g_Mutex)> lock(g_Mutex);

    NN_SDK_REQUIRES_RANGE(index, 0, detail::ipc::ServiceCount);

    NN_SDK_ASSERT(g_Objects[index] == nullptr);

    g_Objects[index] = new (&g_Storages[index]) ServiceCreatorObject(serviceName, capability);
}

void FinalizeServiceCreators() NN_NOEXCEPT
{
    std::lock_guard<decltype (g_Mutex)> lock(g_Mutex);

    for (int i = 0; i < detail::ipc::ServiceCount; i++)
    {
        if (g_Objects[i])
        {
            g_Objects[i]->~ServiceCreatorObject();
            g_Objects[i] = nullptr;
        }
    }
}

nn::sf::SharedPointer<detail::ipc::IServiceCreator> GetServiceCreator(int index) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_RANGE(index, 0, detail::ipc::ServiceCount);

    NN_SDK_ASSERT_NOT_NULL(g_Objects[index]);

    return g_Objects[index]->GetShared();
}

}}}}
