﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/bcat/detail/service/bcat_BcatService.generic.h>
#include <nn/bcat/detail/service/bcat_DeliveryCacheProgressService.generic.h>
#include <nn/bcat/detail/service/bcat_ServiceMemoryManager.h>
#include <nn/bcat/bcat_Result.h>
#include <nn/bcat/detail/bcat_Log.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace bcat { namespace detail { namespace service {

BcatServiceForGeneric::BcatServiceForGeneric() NN_NOEXCEPT
{
}

BcatServiceForGeneric::~BcatServiceForGeneric() NN_NOEXCEPT
{
}

nn::Result BcatServiceForGeneric::RequestSyncDeliveryCache(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService) NN_NOEXCEPT
{
    NN_RESULT_DO(CreateDeliveryCacheProgressService(outService));

    NN_RESULT_SUCCESS;
}

nn::Result BcatServiceForGeneric::RequestSyncDeliveryCacheWithDirectoryName(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, const nn::bcat::DirectoryName& dirName) NN_NOEXCEPT
{
    NN_UNUSED(dirName);

    NN_RESULT_DO(CreateDeliveryCacheProgressService(outService));

    NN_RESULT_SUCCESS;
}

nn::Result BcatServiceForGeneric::CancelSyncDeliveryCacheRequest() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result BcatServiceForGeneric::RequestSyncDeliveryCacheWithApplicationId(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, nn::ApplicationId appId, std::uint32_t appVersion) NN_NOEXCEPT
{
    NN_UNUSED(appId);
    NN_UNUSED(appVersion);

    NN_RESULT_DO(CreateDeliveryCacheProgressService(outService));

    NN_RESULT_SUCCESS;
}

nn::Result BcatServiceForGeneric::RequestSyncDeliveryCacheWithApplicationIdAndDirectoryName(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService, nn::ApplicationId appId, std::uint32_t appVersion, const nn::bcat::DirectoryName& dirName) NN_NOEXCEPT
{
    NN_UNUSED(appId);
    NN_UNUSED(appVersion);
    NN_UNUSED(dirName);

    NN_RESULT_DO(CreateDeliveryCacheProgressService(outService));

    NN_RESULT_SUCCESS;
}

nn::Result BcatServiceForGeneric::SetPassphrase(nn::ApplicationId appId, const nn::sf::InArray<char>& passphrase) NN_NOEXCEPT
{
    NN_UNUSED(appId);
    NN_UNUSED(passphrase);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result BcatServiceForGeneric::RegisterBackgroundDeliveryTask(nn::ApplicationId appId, std::uint32_t appVersion) NN_NOEXCEPT
{
    NN_UNUSED(appId);
    NN_UNUSED(appVersion);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result BcatServiceForGeneric::UnregisterBackgroundDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT
{
    NN_UNUSED(appId);

    NN_RESULT_SUCCESS;
}

nn::Result BcatServiceForGeneric::BlockDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT
{
    NN_UNUSED(appId);

    NN_RESULT_SUCCESS;
}

nn::Result BcatServiceForGeneric::UnblockDeliveryTask(nn::ApplicationId appId) NN_NOEXCEPT
{
    NN_UNUSED(appId);

    NN_RESULT_SUCCESS;
}

nn::Result BcatServiceForGeneric::EnumerateBackgroundDeliveryTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::TaskInfo>& outInfos) NN_NOEXCEPT
{
    NN_UNUSED(outInfos);

    *outCount = 0;

    NN_RESULT_SUCCESS;
}

nn::Result BcatServiceForGeneric::GetDeliveryList(nn::sf::Out<std::uint64_t> outSize, const nn::sf::OutBuffer& buffer, nn::ApplicationId appId) NN_NOEXCEPT
{
    NN_UNUSED(outSize);
    NN_UNUSED(buffer);
    NN_UNUSED(appId);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result BcatServiceForGeneric::ClearDeliveryCacheStorage(nn::ApplicationId appId) NN_NOEXCEPT
{
    NN_UNUSED(appId);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result BcatServiceForGeneric::GetPushNotificationLog(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::bcat::PushNotificationLog>& outLogs) NN_NOEXCEPT
{
    NN_UNUSED(outCount);
    NN_UNUSED(outLogs);

    NN_RESULT_THROW(ResultNotImplemented());
}

nn::Result BcatServiceForGeneric::CreateDeliveryCacheProgressService(nn::sf::Out<nn::sf::SharedPointer<nn::bcat::detail::ipc::IDeliveryCacheProgressService>> outService) NN_NOEXCEPT
{
    auto& allocator = ServiceMemoryManager::GetInstance().GetDeliveryCacheProgressServiceAllocator();

    auto p = nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::
        CreateSharedEmplaced<detail::ipc::IDeliveryCacheProgressService, DeliveryCacheProgressServiceForGeneric>(&allocator);

    NN_RESULT_THROW_UNLESS(p, ResultOutOfSessionResource());

    outService.Set(std::move(p));

    NN_RESULT_SUCCESS;
}

}}}}
