﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/bcat/detail/bcat_ErrorHandler.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>
#include <nn/fs/fs_Result.h>

namespace nn { namespace bcat { namespace detail {

nn::Result HandleError(nn::Result result) NN_NOEXCEPT
{
    if (nn::fs::ResultDataCorrupted::Includes(result))
    {
        NN_SDK_LOG("****** FS ERROR INFORMATION ******\n");
        NN_SDK_LOG("Error: Data is corrupted.\n");

        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    }

    return result;
}

}}}
