﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include <nn/ovln/ovln_SenderForOverlay.h>
#include <nn/ovln/format/ovln_AudioMessage.h>
#include "audioctrl_OverlaySenderController.h"

namespace nn { namespace audioctrl { namespace server { namespace detail {

void OverlaySenderController::Initialize() NN_NOEXCEPT
{
}

void OverlaySenderController::Finalize() NN_NOEXCEPT
{
}

nn::ovln::SenderForOverlayType& OverlaySenderController::GetVolumeChangeMessageSender(VolumeChangeReason reason) NN_NOEXCEPT
{
    switch(reason)
    {
    case VolumeChangeReason::VolumeChanged:
        return m_VolumeChangeSender;
    case VolumeChangeReason::MuteChanged:
        return m_MuteChangeSender;
    case VolumeChangeReason::OutputTargetChanged:
        return m_HeadphoneWarningNoticeSender;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

nn::ovln::format::AudioOutputTarget OverlaySenderController::ConvertToAudioOutputTarget(AudioTarget target) const NN_NOEXCEPT
{
    switch(target)
    {
    case nn::audioctrl::AudioTarget_Speaker:
        return nn::ovln::format::AudioOutputTarget_Speaker;
    case nn::audioctrl::AudioTarget_Headphone:
        return nn::ovln::format::AudioOutputTarget_HeadphoneMicJack;
    case nn::audioctrl::AudioTarget_Tv:
        return nn::ovln::format::AudioOutputTarget_Hdmi;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

void OverlaySenderController::SendVolumeChangeMessage(int volume, bool mute, AudioTarget target, VolumeChangeReason reason, VolumeChangeDetailReasonFlagSet detailReason) NN_NOEXCEPT
{
    NN_UNUSED(volume);
    NN_UNUSED(mute);
    NN_UNUSED(target);
    NN_UNUSED(reason);
    NN_UNUSED(detailReason);
}

void OverlaySenderController::SendHeadphoneVolumeWarningNoticeMessage() NN_NOEXCEPT
{
}

}}}}  // namespace nn::audioctrl::server::detail
