﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gpio/gpio.h>
#include <nn/os.h>

namespace nn { namespace audioctrl { namespace server { namespace detail {

class GpioInterruptHandler
{
    NN_DISALLOW_COPY(GpioInterruptHandler);
    NN_DISALLOW_MOVE(GpioInterruptHandler);

public:
    GpioInterruptHandler() NN_NOEXCEPT;
    GpioInterruptHandler(nn::gpio::GpioPadName name, nn::gpio::Direction direction, nn::gpio::InterruptMode mode) NN_NOEXCEPT;
    void Initialize(nn::gpio::GpioPadName name, nn::gpio::Direction direction, nn::gpio::InterruptMode mode) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void LinkMultiWait(nn::os::MultiWaitType* pWaiter) NN_NOEXCEPT;
    void Clear() NN_NOEXCEPT;
    bool IsHigh() NN_NOEXCEPT;
    bool IsLow() NN_NOEXCEPT;
    nn::os::SystemEventType* GetSystemEvent() NN_NOEXCEPT;

private:
    nn::gpio::GpioPadSession m_Gpio;
    nn::os::MultiWaitHolderType m_EventHolder;
    nn::os::SystemEventType m_Event;
};

}}}}  // namespace nn::audioctrl::server::detail
