﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/settings/system/settings_Audio.h>
#include <nn/audioctrl/audioctrl_AudioControllerTypes.h>
#include <nn/audioctrl/audioctrl_PlayReport.h>
#include "audioctrl_OverlaySenderController.h"

namespace nn { namespace audioctrl { namespace server { namespace detail {

class AudioControllerServiceImpl
{
protected:
    OverlaySenderController m_OverlaySenderController;
    nn::os::Mutex m_Mutex;
    bool m_IsTargetsConnected[AudioTarget_Count];
    AudioOutputMode m_AudioOutputMode[AudioTarget_Count];
    nn::settings::system::AudioVolume m_AudioVolumes[AudioTarget_Count];
    nn::os::SystemEvent m_AudioVolumeUpdateEventForPlayReport;
    nn::os::SystemEvent m_AudioOutputDeviceUpdateEventForPlayReport;
    AudioTarget m_CurrentAudioOutputTarget;
    int m_HeadphoneVolumeWarningDisplayedEventCount;
    AudioTarget m_DefaultOutput;
    const int VolumeMin = 1;
    const int VolumeMax = 1;
    bool m_IsInitialized;
    float m_SystemOutputMasterVolume;


protected:
    nn::settings::system::AudioVolumeTarget ConvertToAudioVolumeTarget(AudioTarget target) NN_NOEXCEPT;
    nn::settings::system::AudioOutputModeTarget ConvertToAudioOutputModeTarget(AudioTarget target) NN_NOEXCEPT;
    PlayReportAudioOutputTarget ConvertToPlayReportAudioOutputTarget(AudioTarget target) NN_NOEXCEPT;
    nn::settings::system::AudioOutputMode ConvertToAudioOutputMode(AudioOutputMode mode) NN_NOEXCEPT;
    AudioOutputMode ConvertToAudioOutputMode(nn::settings::system::AudioOutputMode mode) NN_NOEXCEPT;
    bool IsValidAudioTargetForOutputMode(AudioTarget target) NN_NOEXCEPT;
    bool IsValidTargetForOutputTarget(AudioTarget target) NN_NOEXCEPT;
    bool IsValidOutputMode(AudioOutputMode mode) NN_NOEXCEPT;

public:
    AudioControllerServiceImpl() NN_NOEXCEPT;
    void Initialize(bool hasCodecIc, bool hasHda, bool isUacEnabled) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void Sleep() NN_NOEXCEPT;
    void Wake() NN_NOEXCEPT;
    void SetTargetVolume(AudioTarget target, int8_t volume) NN_NOEXCEPT;
    int8_t GetTargetVolume(AudioTarget target) NN_NOEXCEPT;
    void SetTargetMute(AudioTarget target, bool isMute) NN_NOEXCEPT;
    bool IsTargetMute(AudioTarget target) NN_NOEXCEPT;
    void SaveTargetVolumeSetting(AudioTarget target) NN_NOEXCEPT;
    int GetTargetVolumeMin() NN_NOEXCEPT;
    int GetTargetVolumeMax() NN_NOEXCEPT;
    void SetTargetConnected(AudioTarget target, bool isConnected) NN_NOEXCEPT;
    bool IsTargetConnected(AudioTarget target) NN_NOEXCEPT;
    bool SetDefaultTarget(AudioTarget target, nn::TimeSpanType fadeOutTime, nn::TimeSpanType fadeInTime) NN_NOEXCEPT;
    AudioTarget GetDefaultTarget() NN_NOEXCEPT;
    AudioOutputMode GetOutputModeSetting(AudioTarget target) NN_NOEXCEPT;
    void SetOutputModeSetting(AudioTarget target, AudioOutputMode mode) NN_NOEXCEPT;
    AudioOutputMode GetAudioOutputMode(AudioTarget target) NN_NOEXCEPT;
    void SetAudioOutputMode(AudioTarget target, AudioOutputMode mode) NN_NOEXCEPT;
    void SetForceMutePolicy(ForceMutePolicy policy) NN_NOEXCEPT;
    void SetOutputTarget(AudioTarget target) NN_NOEXCEPT;
    ForceMutePolicy GetForceMutePolicy() NN_NOEXCEPT;
    void SetInputTargetForceEnabled(bool isEnabled) NN_NOEXCEPT;
    void SetHeadphoneOutputLevelMode(HeadphoneOutputLevelMode mode) NN_NOEXCEPT;
    HeadphoneOutputLevelMode GetHeadphoneOutputLevelMode() NN_NOEXCEPT;
    void AcquireAudioVolumeUpdateEventForPlayReport(nn::os::NativeHandle* outHandle) NN_NOEXCEPT;
    void AcquireAudioOutputDeviceUpdateEventForPlayReport(nn::os::NativeHandle* outHandle) NN_NOEXCEPT;
    void NotifyAudioOutputTarget(AudioTarget target) NN_NOEXCEPT;
    void NotifyUnsupportedUsbOutputDeviceAttached() NN_NOEXCEPT;
    PlayReportAudioOutputTarget GetAudioOutputTargetForPlayReport() NN_NOEXCEPT;
    void GetAudioVolumeDataForPlayReport(PlayReportAudioVolumeData* pOutData) NN_NOEXCEPT;
    void NotifyHeadphoneVolumeWarningDisplayedEvent() NN_NOEXCEPT;
    int GetHeadphoneVolumeWarningDisplayedEventCount() NN_NOEXCEPT;
    int GetHeadphoneRs1VolumeMax(HeadphoneOutputLevelMode mode) NN_NOEXCEPT;
    OverlaySenderController& GetOverlaySenderController() NN_NOEXCEPT;
    bool IsHeadphoneVolumeWarningTransmissionNeeded() NN_NOEXCEPT;
    void SetSystemOutputMasterVolume(float volume) NN_NOEXCEPT;
    float GetSystemOutputMasterVolume() NN_NOEXCEPT;
    bool NeedsToUpdateHeadphoneVolume(bool* pOutIsHighPowerAvailable, int8_t* pOutVolume, bool isRestricted) NN_NOEXCEPT;
};

}}}}  // namespace nn::audioctrl::server::detail
