﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_TimeSpan.h>
#include <nn/audioctrl/audioctrl_AudioControllerTypes.h>
#include <nn/audioctrl/audioctrl_PlayReport.h>
#include "audioctrl_AudioControllerService.h"

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
#include "audioctrl_AudioControllerServiceImpl-os.horizon.h"
#elif defined(NN_BUILD_CONFIG_OS_WIN)
#include "audioctrl_AudioControllerServiceImpl-os.win32.h"
#else
#error Unsupported platform.
#endif


namespace nn { namespace audioctrl { namespace server { namespace detail {

namespace {

AudioControllerServiceImpl g_ServiceImpl;

} // namespace

void InitializeAudioControllerService(bool hasCodecIc, bool hasHda, bool isUacEnabled) NN_NOEXCEPT
{
    g_ServiceImpl.Initialize(hasCodecIc, hasHda, isUacEnabled);
}

void FinalizeAudioControllerService() NN_NOEXCEPT
{
    g_ServiceImpl.Finalize();
}

void SleepAudioControllerService() NN_NOEXCEPT
{
    g_ServiceImpl.Sleep();
}

void WakeAudioControllerService() NN_NOEXCEPT
{
    g_ServiceImpl.Wake();
}

void SetTargetVolume(AudioTarget target, int8_t volume) NN_NOEXCEPT
{
    g_ServiceImpl.SetTargetVolume(target, volume);
}

int8_t GetTargetVolume(AudioTarget target) NN_NOEXCEPT
{
    return g_ServiceImpl.GetTargetVolume(target);
}

void SetTargetMute(AudioTarget target, bool isMute) NN_NOEXCEPT
{
    g_ServiceImpl.SetTargetMute(target, isMute);
}

bool IsTargetMute(AudioTarget target) NN_NOEXCEPT
{
    return g_ServiceImpl.IsTargetMute(target);
}

void SaveTargetVolumeSetting(AudioTarget target) NN_NOEXCEPT
{
    g_ServiceImpl.SaveTargetVolumeSetting(target);
}

int GetTargetVolumeMin() NN_NOEXCEPT
{
    return g_ServiceImpl.GetTargetVolumeMin();
}

int GetTargetVolumeMax() NN_NOEXCEPT
{
    return g_ServiceImpl.GetTargetVolumeMax();
}

void SetTargetConnected(AudioTarget target, bool isConnected) NN_NOEXCEPT
{
    g_ServiceImpl.SetTargetConnected(target, isConnected);
}

bool IsTargetConnected(AudioTarget target) NN_NOEXCEPT
{
    return g_ServiceImpl.IsTargetConnected(target);
}

bool SetDefaultTarget(AudioTarget target, nn::TimeSpanType fadeOutTime, nn::TimeSpanType fadeInTime) NN_NOEXCEPT
{
    return g_ServiceImpl.SetDefaultTarget(target, fadeOutTime, fadeInTime);
}

AudioTarget GetDefaultTarget() NN_NOEXCEPT
{
    return g_ServiceImpl.GetDefaultTarget();
}

AudioOutputMode GetOutputModeSetting(AudioTarget target) NN_NOEXCEPT
{
    return g_ServiceImpl.GetOutputModeSetting(target);
}

void SetOutputModeSetting(AudioTarget target, AudioOutputMode mode) NN_NOEXCEPT
{
    return g_ServiceImpl.SetOutputModeSetting(target, mode);
}

AudioOutputMode GetAudioOutputMode(AudioTarget target) NN_NOEXCEPT
{
    return g_ServiceImpl.GetAudioOutputMode(target);
}

void SetAudioOutputMode(AudioTarget target, AudioOutputMode mode) NN_NOEXCEPT
{
    g_ServiceImpl.SetAudioOutputMode(target, mode);
}

void SetForceMutePolicy(ForceMutePolicy policy) NN_NOEXCEPT
{
    return g_ServiceImpl.SetForceMutePolicy(policy);
}

ForceMutePolicy GetForceMutePolicy() NN_NOEXCEPT
{
    return g_ServiceImpl.GetForceMutePolicy();
}

void SetOutputTarget(AudioTarget target) NN_NOEXCEPT
{
    g_ServiceImpl.SetOutputTarget(target);
}

void SetInputTargetForceEnabled(bool isEnabled) NN_NOEXCEPT
{
    g_ServiceImpl.SetInputTargetForceEnabled(isEnabled);
}

void SetHeadphoneOutputLevelMode(HeadphoneOutputLevelMode mode) NN_NOEXCEPT
{
    g_ServiceImpl.SetHeadphoneOutputLevelMode(mode);
}

HeadphoneOutputLevelMode GetHeadphoneOutputLevelMode() NN_NOEXCEPT
{
    return g_ServiceImpl.GetHeadphoneOutputLevelMode();
}

void AcquireAudioVolumeUpdateEventForPlayReport(nn::os::NativeHandle* outHandle) NN_NOEXCEPT
{
    g_ServiceImpl.AcquireAudioVolumeUpdateEventForPlayReport(outHandle);
}

void AcquireAudioOutputDeviceUpdateEventForPlayReport(nn::os::NativeHandle* outHandle) NN_NOEXCEPT
{
    g_ServiceImpl.AcquireAudioOutputDeviceUpdateEventForPlayReport(outHandle);
}

void NotifyAudioOutputTarget(AudioTarget target) NN_NOEXCEPT
{
    g_ServiceImpl.NotifyAudioOutputTarget(target);
}

void NotifyUnsupportedUsbOutputDeviceAttached() NN_NOEXCEPT
{
    g_ServiceImpl.NotifyUnsupportedUsbOutputDeviceAttached();
}

PlayReportAudioOutputTarget GetAudioOutputTargetForPlayReport() NN_NOEXCEPT
{
    return g_ServiceImpl.GetAudioOutputTargetForPlayReport();
}

void GetAudioVolumeDataForPlayReport(PlayReportAudioVolumeData* pOutData) NN_NOEXCEPT
{
    return g_ServiceImpl.GetAudioVolumeDataForPlayReport(pOutData);
}

void NotifyHeadphoneVolumeWarningDisplayedEvent() NN_NOEXCEPT
{
    g_ServiceImpl.NotifyHeadphoneVolumeWarningDisplayedEvent();
}

int GetHeadphoneVolumeWarningDisplayedEventCount() NN_NOEXCEPT
{
    return g_ServiceImpl.GetHeadphoneVolumeWarningDisplayedEventCount();
}

int GetHeadphoneRs1VolumeMax(HeadphoneOutputLevelMode mode) NN_NOEXCEPT
{
    return g_ServiceImpl.GetHeadphoneRs1VolumeMax(mode);
}

OverlaySenderController& GetOverlaySenderController() NN_NOEXCEPT
{
    return g_ServiceImpl.GetOverlaySenderController();
}

bool IsHeadphoneVolumeWarningTransmissionNeeded() NN_NOEXCEPT
{
    return g_ServiceImpl.IsHeadphoneVolumeWarningTransmissionNeeded();
}

void SetSystemOutputMasterVolume(float volume) NN_NOEXCEPT
{
    g_ServiceImpl.SetSystemOutputMasterVolume(volume);
}

float GetSystemOutputMasterVolume() NN_NOEXCEPT
{
    return g_ServiceImpl.GetSystemOutputMasterVolume();
}

bool NeedsToUpdateHeadphoneVolume(bool* pOutIsHighPowerAvailable, int8_t* pOutVolume, bool isRestricted) NN_NOEXCEPT
{
    return g_ServiceImpl.NeedsToUpdateHeadphoneVolume(pOutIsHighPowerAvailable, pOutVolume, isRestricted);
}

}}}}  // namespace nn::audioctrl::server::detail
