﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include <nn/audio/detail/audio_IAudioRendererManager.h>
#include <nn/audio/detail/audio_IAudioRendererManagerForDebugger.h>
#include "audio_CreateAudioRendererManager.h"
#include "audio_ServiceName.h"
#include "../server/audio_AudioRendererManagerImpl.h"
#include "../server/audio_AudioRendererManagerForAppletImpl.h"
#include "../server/audio_AudioRendererManagerForDebuggerImpl.h"

namespace nn {
namespace audio {

namespace {

struct CreateAudioRendererManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateAudioRendererManagerByHipcTag> MyAllocator;

class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_MyAllocatorInitializer;

}  // namespace anonymous

nn::sf::SharedPointer<detail::IAudioRendererManager> CreateAudioRendererManagerByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IAudioRendererManager> ret;
    auto result = nn::sf::CreateHipcProxyByName<detail::IAudioRendererManager, MyAllocator::Policy>(&ret, AudioRendererServiceForUserName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return ret;
}

nn::sf::SharedPointer<detail::IAudioRendererManagerForApplet> CreateAudioRendererManagerForAppletByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IAudioRendererManagerForApplet> ret;
    auto result = nn::sf::CreateHipcProxyByName<detail::IAudioRendererManagerForApplet, MyAllocator::Policy>(&ret, AudioRendererServiceForAppletName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return ret;
}

nn::sf::SharedPointer<detail::IAudioRendererManagerForDebugger> CreateAudioRendererManagerForDebuggerByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IAudioRendererManagerForDebugger> ret;
    auto result = nn::sf::CreateHipcProxyByName<detail::IAudioRendererManagerForDebugger, MyAllocator::Policy>(&ret, AudioRendererServiceForDebuggerName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return ret;
}

}  // namespace audio
}  // namespace nn
