﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include "audio_CreateAudioOutManager.h"
#include "audio_ServiceName.h"
#include "../server/audio_AudioOutManagerImpl.h"

#include "../server/audio_AudioOutManagerForAppletImpl.h"
#include "../server/audio_AudioOutManagerForDebuggerImpl.h"

namespace nn {
namespace audio {

namespace {

struct CreateAudioOutManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateAudioOutManagerByHipcTag> MyAllocator;

class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_MyAllocatorInitializer;

}  // namespace anonymous

nn::sf::SharedPointer<detail::IAudioOutManager> CreateAudioOutManagerByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IAudioOutManager> ret;
    auto result = nn::sf::CreateHipcProxyByName<detail::IAudioOutManager, MyAllocator::Policy>(&ret, AudioOutServiceForUserName);
    NN_ABORT_UNLESS(result.IsSuccess());
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return ret;
}

nn::sf::SharedPointer<detail::IAudioOutManagerForApplet> CreateAudioOutManagerForAppletByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IAudioOutManagerForApplet> ret;
    auto result = nn::sf::CreateHipcProxyByName<detail::IAudioOutManagerForApplet, MyAllocator::Policy>(&ret, AudioOutServiceForAppletName);
    NN_ABORT_UNLESS(result.IsSuccess());
    return ret;
}

nn::sf::SharedPointer<detail::IAudioOutManagerForDebugger> CreateAudioOutManagerForDebuggerByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<detail::IAudioOutManagerForDebugger> ret;
    auto result = nn::sf::CreateHipcProxyByName<detail::IAudioOutManagerForDebugger, MyAllocator::Policy>(&ret, AudioOutServiceForDebuggerName);
    NN_ABORT_UNLESS(result.IsSuccess());
    return ret;
}

}  // namespace audio
}  // namespace nn
