﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_SdkAssert.h>
#include "audio_CreateAudioOutManager.h"

namespace nn {
namespace audio {

namespace {

nn::sf::SharedPointer<detail::IAudioOutManagerForDebugger> CreateAudioOutManagerForDebugger() NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    return CreateAudioOutManagerForDebuggerByHipc();
#else
    return CreateAudioOutManagerForDebuggerByDfc();
#endif
}

} // anonymous namespace

nn::Result RequestSuspendAudioOutsForDebug(nn::applet::AppletResourceUserId id) NN_NOEXCEPT
{
    auto audioRendererManagerForDebugger = CreateAudioOutManagerForDebugger();
    NN_RESULT_DO(audioRendererManagerForDebugger->RequestSuspend(id));

    NN_RESULT_SUCCESS;
}

nn::Result RequestResumeAudioOutsForDebug(nn::applet::AppletResourceUserId id) NN_NOEXCEPT
{
    auto audioRendererManagerForDebugger = CreateAudioOutManagerForDebugger();
    NN_RESULT_DO(audioRendererManagerForDebugger->RequestResume(id));

    NN_RESULT_SUCCESS;
}

}  // namespace audio
}  // namespace nn
