﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.audio
{
    [CppRefPath(@"<nn/audio/audio_FinalOutputRecorderTypes.h>")]
    [ExternalStruct(8, 4)]
    public struct FinalOutputRecorderParameter
    {
    }
}

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_Types.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }
}

namespace nn.audio.detail
{
    [CppRefPath("<nn/audio/detail/audio_FinalOutputRecorderTypesInternal.h>")]
    public struct FinalOutputRecorderParameterInternal
    {
        public int32_t sampleRate;
        public int32_t channelCount;
        public int32_t sampleFormat;
        public int32_t state;
    }

    [CppRefPath(@"<nn/audio/detail/audio_IFinalOutputRecorder.h>")]
    interface IFinalOutputRecorder : IServiceObject
    {
        [MethodId(0)]
        Result GetFinalOutputRecorderState(Out<uint32_t> outFinalOutputRecorder);

        [MethodId(1)]
        Result Start();

        [MethodId(2)]
        Result Stop();

        [MethodId(3)]
        Result AppendFinalOutputRecorderBuffer(InBuffer outFinalOutputRecorderBuffer, uint64_t outBufferClientPtr);

        // This event will be signaled when there are released buffers to retrieve.
        [MethodId(4)]
        Result RegisterBufferEvent(Out<NativeHandle> bufferEvent);

        // Return all released buffers in a single call.
        [MethodId(5)]
        Result GetReleasedFinalOutputRecorderBuffers(OutBuffer outFinalOutputRecorderBuffer, Out<int> count, Out<int64_t> released);

        [MethodId(6)]
        Result ContainsFinalOutputRecorderBuffer(uint64_t FinalOutputRecorderBufferPointer, Out<bool> contains);

        [MethodId(7)]
        Result GetFinalOutputRecorderBufferEndTime(uint64_t FinalOutputRecorderBufferPointer, Out<int64_t> released);

        [MethodId(8)]
        Result AppendFinalOutputRecorderBufferAuto([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]InBuffer outFinalOutputRecorderBuffer,
                                                    uint64_t outBufferClientPtr);

        [MethodId(9)]
        Result GetReleasedFinalOutputRecorderBuffersAuto([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]OutBuffer outFinalOutputRecorderBuffer,
                                                            Out<int> count, Out<int64_t> released);
    }

    [CppRefPath(@"<nn/audio/detail/audio_IFinalOutputRecorderManager.h>")]
    interface IFinalOutputRecorderManager : IServiceObject
    {
        // If the name is "", then it is the default output.
        // If sampleRate is 0, then it is the default sample rate.
        [MethodId(0)]
        Result OpenFinalOutputRecorder(Out<IFinalOutputRecorder> outFinalOutputRecorder, nn.audio.FinalOutputRecorderParameter param, NativeHandle processHandle, Out<nn.audio.detail.FinalOutputRecorderParameterInternal> outFinalOutputRecorderInternal, nn.applet.AppletResourceUserId appletId);

        // this is for debug usecases
        [MethodId(1000)]
        Result GetAdspLoad(Out<int> value);
    }
}
