﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Applet;
using nn;
using nn.sf;
using std;

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nn.audio
{
namespace detail
{
    [CppRefPath("<nn/audio/detail/audio_AudioRendererTypesInternal.h>")]
    public struct AudioRendererParameterInternal
    {
        public int32_t sampleRate;
        public int32_t sampleCount;
        public int32_t mixBufferCount;
        public int32_t subMixCount;
        public int32_t voiceCount;
        public int32_t sinkCount;
        public int32_t effectCount;
        public int32_t performanceFrameCount;
        public bool isVoiceDropEnabled;
        [FixedArray(1)]
        public int8_t[] _reserved1;
        public int8_t renderingDevice;
        public int8_t executionMode;
        public int32_t splitterCount;
        public int32_t splitterSendChannelCount;
        public int32_t bufferSizeForAudioCodec;
        public uint32_t _magic;
    }

    [CppRefPath("<nn/audio/detail/audio_IAudioRenderer.h>")]
    interface IAudioRenderer : IServiceObject
    {
        [MethodId(0)]
        Result GetSampleRate(Out<int32_t> sampleRate);

        [MethodId(1)]
        Result GetSampleCount(Out<int32_t> sampleCount);

        [MethodId(2)]
        Result GetMixBufferCount(Out<int32_t> mixBufferCount);

        [MethodId(3)]
        Result GetState(Out<int32_t> state);

        [MethodId(4)]
        Result RequestUpdate(OutBuffer pOutBuffer, OutBuffer pPerformanceBuffer, InBuffer pInBuffer);

        [MethodId(5)]
        Result Start();

        [MethodId(6)]
        Result Stop();

        [MethodId(7)]
        Result QuerySystemEvent(Out<NativeHandle> handle);

        [MethodId(8)]
        Result SetRenderingTimeLimit(int32_t limitPercent);

        [MethodId(9)]
        Result GetRenderingTimeLimit(Out<int32_t> limitPercent);

        [MethodId(10)]
        Result RequestUpdateAuto([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]OutBuffer pOutBuffer,
                                    [Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]OutBuffer pPerformanceBuffer,
                                    [Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]InBuffer pInBuffer);

        [MethodId(11)]
        Result ExecuteAudioRendererRendering();
    }

    [CppRefPath("<nn/audio/detail/audio_IAudioDevice.h>")]
    interface IAudioDevice : IServiceObject
    {
        [MethodId(0)]
        Result ListAudioDeviceName(OutBuffer outDeviceNames, Out<int> amountRet);

        [MethodId(1)]
        Result SetAudioDeviceOutputVolume(InBuffer nameIn, float volume);

        [MethodId(2)]
        Result GetAudioDeviceOutputVolume(InBuffer nameIn, Out<float> pOutVolume);

        [MethodId(3)]
        Result GetActiveAudioDeviceName(OutBuffer outDeviceName);

        [MethodId(4)]
        Result QueryAudioDeviceSystemEvent(Out<NativeHandle> handle);

        [MethodId(5)]
        Result GetActiveChannelCount(Out<int> channelCount);

        [MethodId(6)]
        Result ListAudioDeviceNameAuto([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]OutBuffer outDeviceNames,
                                        Out<int> amountRet);

        [MethodId(7)]
        Result SetAudioDeviceOutputVolumeAuto([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]InBuffer nameIn,
                                            float volume);

        [MethodId(8)]
        Result GetAudioDeviceOutputVolumeAuto([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]InBuffer nameIn,
                                                Out<float> pOutVolume);

        [MethodId(10)]
        Result GetActiveAudioDeviceNameAuto([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer]OutBuffer outDeviceName);

        [MethodId(11)]
        Result QueryAudioDeviceInputEvent(Out<NativeHandle> handle);

        [MethodId(12)]
        Result QueryAudioDeviceOutputEvent(Out<NativeHandle> handle);

        [MethodId(13)]
        Result GetAudioSystemMasterVolumeSetting(Out<float> volume, InBuffer name);
    }

    [CppRefPath("<nn/audio/detail/audio_IAudioRendererManager.h>")]
    interface IAudioRendererManager : IServiceObject
    {
        [MethodId(0)]
        Result OpenAudioRenderer(Out<IAudioRenderer> outAudioRenderer, AudioRendererParameterInternal parameter, NativeHandle workBufferHandle, NativeHandle processHandle, uint64_t size, nn.applet.CheckedAppletResourceUserId id);

        [MethodId(1)]
        Result GetWorkBufferSize(Out<int64_t> size, AudioRendererParameterInternal parameter);

        [MethodId(2)]
        Result GetAudioDeviceService(Out<IAudioDevice> outAudioDeviceService, nn.applet.AppletResourceUserId id);

        [MethodId(3)]
        Result OpenAudioRendererForManualExecution(Out<IAudioRenderer> outAudioRenderer, AudioRendererParameterInternal parameter, uint64_t workBufferAddress, NativeHandle processHandle, uint64_t size, nn.applet.CheckedAppletResourceUserId id);

        [MethodId(4)]
        Result GetAudioDeviceServiceWithRevisionInfo(Out<IAudioDevice> outAudioDeviceService, nn.applet.AppletResourceUserId id, uint32_t revisionInfo);
    }

    [CppRefPath("<nn/audio/detail/audio_IAudioRendererManagerForApplet.h>")]
    interface IAudioRendererManagerForApplet : IServiceObject
    {
        [MethodId(0)]
        Result RequestSuspend(nn.applet.AppletResourceUserId id, int64_t fadeTimeNanoSeconds);

        [MethodId(1)]
        Result RequestResume(nn.applet.AppletResourceUserId id, int64_t fadeTimeNanoSeconds);

        [MethodId(2)]
        Result GetProcessMasterVolume(Out<float> pOutVolume, nn.applet.AppletResourceUserId id);

        [MethodId(3)]
        Result SetProcessMasterVolume(nn.applet.AppletResourceUserId id, float volume, int64_t fadeTimeNanoSeconds);

        [MethodId(4)]
        Result RegisterAppletResourceUserId(nn.applet.AppletResourceUserId id);

        [MethodId(5)]
        Result UnregisterAppletResourceUserId(nn.applet.AppletResourceUserId id);

        [MethodId(6)]
        Result GetProcessRecordVolume(Out<float> pOutVolume, nn.applet.AppletResourceUserId id);

        [MethodId(7)]
        Result SetProcessRecordVolume(nn.applet.AppletResourceUserId id, float volume, int64_t fadeTimeNanoSeconds);
    }

    [CppRefPath("<nn/audio/detail/audio_IAudioRendererManagerForDebugger.h>")]
    interface IAudioRendererManagerForDebugger : IServiceObject
    {
        [MethodId(0)]
        Result RequestSuspend(nn.applet.AppletResourceUserId id);

        [MethodId(1)]
        Result RequestResume(nn.applet.AppletResourceUserId id);
    }
}
}
