﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audio/audio_Result.h>
#include <nn/applet/applet_Types.h>

#include "audio_AudioDriver.h"
#include "../audio_AudioSessionTypes.h"

namespace nn {
namespace audio {
namespace detail {

class AudioUnimplementedDriver : public AudioDriver
{
public:
    AudioUnimplementedDriver() NN_NOEXCEPT;
    ~AudioUnimplementedDriver() NN_NOEXCEPT;
    Result Close() NN_NOEXCEPT;
    Result Open(server::SessionType sessionType, AppletVolumeManager::SessionType avmType, const char* name, server::SessionFormat& format, int sessionId, nn::dd::ProcessHandle processHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    Result Start() NN_NOEXCEPT;
    Result Stop() NN_NOEXCEPT;
    Result Sleep() NN_NOEXCEPT;
    Result Wake() NN_NOEXCEPT;
    uint64_t GetSamplesProcessed() const NN_NOEXCEPT;
    void* MapBuffer(server::SessionBuffer& buffer, nn::dd::ProcessHandle processHandle) NN_NOEXCEPT;
    void* MapBuffer(server::SessionBuffer& buffer, nn::sf::NativeHandle&& bufferHandle) NN_NOEXCEPT;
    bool UnmapBuffer(const server::SessionBuffer& buffer) NN_NOEXCEPT;
    bool TryCompleteBuffer(const server::SessionBuffer& buffer) NN_NOEXCEPT;
    Result AppendBuffer(const server::SessionBuffer& buffer) NN_NOEXCEPT;
    void* GetBufferAddress() const NN_NOEXCEPT;
    Result SetDeviceGain(float gain) NN_NOEXCEPT;
    float GetDeviceGain() const NN_NOEXCEPT;
};

}  // namespace detail
}  // namespace audio
}  // namespace nn
