﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/audio/audio_FinalOutputRecorderTypes.h>
#include "../audio_AudioSession.h"
#include "audio_AudioUnimplementedDriver.h"
#include "../audio_FinalOutputRecorderManagerImpl.h"

namespace nn {
namespace audio {

namespace server {
void InitializeFinalOutputRecorder(nn::os::SemaphoreType* pSemaphore, nn::os::EventType* pEventSemaphore) NN_NOEXCEPT;

void FinalizeFinalOutputRecorder() NN_NOEXCEPT;
} // namespace server

namespace detail {

class AudioRecordSession : public AudioSession<nn::audio::AudioOutBufferCountMax, 4>
{
public:
    AudioRecordSession(int32_t sessionId, nn::os::SystemEvent& releaseClientBufferEvent) NN_NOEXCEPT;
    virtual ~AudioRecordSession() NN_NOEXCEPT;
    virtual const char* GetDefaultName() const NN_NOEXCEPT;
    virtual Result IsSupported(const char* name, const server::SessionFormat& format) const NN_NOEXCEPT;
    FinalOutputRecorderState GetState() const NN_NOEXCEPT;
    void SetAudioOutVolume(float volume) NN_NOEXCEPT;
    float GetAudioOutVolume() const NN_NOEXCEPT;

private:
    AudioDriver* GetDriver(int sessionId) const NN_NOEXCEPT;

private:
    static AudioUnimplementedDriver s_StubDriver[server::FinalOutputRecorderManagerImpl::NumberOfFinalOutputRecorderSessions];
};

}  // namespace detail
}  // namespace audio
}  // namespace nn
