﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../audio_AppletVolumeManager.h"
#include "../audio_AudioSessionTypes.h"
#include <nn/audio/audio_Result.h>

namespace nn {
namespace audio {
namespace detail {

class AudioDriver
{
public:
    virtual ~AudioDriver() NN_NOEXCEPT {};
    virtual Result Close() NN_NOEXCEPT = 0;
    virtual Result Open(server::SessionType sessionType, AppletVolumeManager::SessionType avmType, const char* name, server::SessionFormat& format, int sessionId, nn::dd::ProcessHandle processHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT = 0;
    virtual Result Start() NN_NOEXCEPT = 0;
    virtual Result Stop() NN_NOEXCEPT = 0;
    virtual Result Sleep() NN_NOEXCEPT = 0;
    virtual Result Wake() NN_NOEXCEPT = 0;
    virtual uint64_t GetSamplesProcessed() const NN_NOEXCEPT = 0;
    virtual void* MapBuffer(server::SessionBuffer& buffer, nn::dd::ProcessHandle processHandle) NN_NOEXCEPT = 0;
    virtual void* MapBuffer(server::SessionBuffer& buffer, nn::sf::NativeHandle&& bufferHandle) NN_NOEXCEPT = 0;
    virtual bool UnmapBuffer(const server::SessionBuffer& buffer) NN_NOEXCEPT = 0;
    virtual bool TryCompleteBuffer(const server::SessionBuffer& buffer) NN_NOEXCEPT = 0;
    virtual Result AppendBuffer(const server::SessionBuffer& buffer) NN_NOEXCEPT = 0;
    virtual void* GetBufferAddress() const NN_NOEXCEPT = 0;
    virtual Result SetDeviceGain(float gain) NN_NOEXCEPT = 0;
    virtual float GetDeviceGain() const NN_NOEXCEPT = 0;
};

}  // namespace detail
}  // namespace audio
}  // namespace nn
